/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.jenkinsci.plugins.build_monitor.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProjectStatus {
    Successful("successful"),
    Failing("failing"),
    Unknown("unknown"),
    Claimed("claimed");

    private final String value;

    private ProjectStatus(String value) {
        this.value = value;
    }

    public static List<ProjectStatus> fromMultiple(String cssClasses) {
        ArrayList<ProjectStatus> statuses = new ArrayList<ProjectStatus>();
        for (String statusClass : ProjectStatus.projectStatusClasses()) {
            if (!ProjectStatus.setOf(ProjectStatus.split(cssClasses)).contains(statusClass)) continue;
            statuses.add(ProjectStatus.from(statusClass));
        }
        return statuses;
    }

    public static ProjectStatus from(@NonNull String cssClass) {
        for (ProjectStatus status : ProjectStatus.values()) {
            if (!cssClass.equalsIgnoreCase(status.value)) continue;
            return status;
        }
        throw new IllegalArgumentException(String.format("'%s' is not a recognised value of the ProjectStatus enum", cssClass));
    }

    private static Set<String> projectStatusClasses() {
        return ProjectStatus.setOf(ProjectStatus.stringRepresentationsOf(EnumSet.allOf(ProjectStatus.class)));
    }

    private static List<String> split(String spaceSeparatedItems) {
        return Stream.of(spaceSeparatedItems.split("\\s+")).collect(Collectors.toList());
    }

    private static <T> Set<T> setOf(List<T> items) {
        return Set.copyOf(items);
    }

    private static <T> List<String> stringRepresentationsOf(Collection<T> items) {
        return items.stream().map(Object::toString).collect(Collectors.toList());
    }

    public String toString() {
        return this.value;
    }
}

