/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.jenkins.actions;

import java.util.List;
import net.serenitybdd.annotations.Step;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Tasks;
import net.serenitybdd.screenplay.actions.Click;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplayx.actions.Evaluate;

public class EnterCode {
    private final List<String> lines;

    public static EnterCode asFollows(String ... lines) {
        return new EnterCode(List.of(lines));
    }

    public Interaction intoTheCodeMirror(Target editorField) {
        return (Interaction)Tasks.instrumented(EnterCodeIntoCodeMirrorEditor.class, (Object[])new Object[]{editorField, String.join((CharSequence)System.lineSeparator(), this.lines)});
    }

    public Interaction intoThePipelineEditor(Target editorField) {
        return (Interaction)Tasks.instrumented(EnterCodeIntoPipelineEditor.class, (Object[])new Object[]{editorField, String.join((CharSequence)System.lineSeparator(), this.lines)});
    }

    public EnterCode(List<String> lines) {
        this.lines = lines;
    }

    public static class EnterCodeIntoCodeMirrorEditor
    implements Interaction {
        private final Target target;
        private final String code;

        public EnterCodeIntoCodeMirrorEditor(Target target, String code) {
            this.target = target;
            this.code = code;
        }

        @Step(value="{0} enters '#code' into the code editor field")
        public <T extends Actor> void performAs(T actor) {
            actor.attemptsTo(new Performable[]{Click.on((Target)this.target), Evaluate.javascript(this.setCodeMirrorValueTo(this.code), this.target.resolveFor(actor))});
        }

        private String setCodeMirrorValueTo(String code) {
            return String.format("var code_mirror = arguments[0].CodeMirror;if (code_mirror != null) {     code_mirror.setValue('%s');    code_mirror.save();} else {     console.error('CodeMirror object is not present on the', arguments[0], 'element'); }", this.escapeNewLineCharacters(code));
        }

        private String escapeNewLineCharacters(String code) {
            return code.replaceAll("\n", "\\\\n");
        }
    }

    private static class EnterCodeIntoPipelineEditor
    implements Interaction {
        private final Target target;
        private final String code;

        public EnterCodeIntoPipelineEditor(Target target, String code) {
            this.target = target;
            this.code = code;
        }

        @Step(value="{0} enters '#code' into the pipeline editor field")
        public <T extends Actor> void performAs(T actor) {
            this.target.resolveFor(actor).type(new CharSequence[]{this.code});
        }
    }
}

