/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.integration.jenkins;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.serenitybdd.integration.jenkins.client.JenkinsClient;
import net.serenitybdd.integration.jenkins.environment.PluginDescription;
import net.serenitybdd.integration.jenkins.environment.rules.ApplicativeTestRule;
import net.serenitybdd.integration.jenkins.environment.rules.InstallPlugins;
import net.serenitybdd.integration.jenkins.environment.rules.ManageJenkinsServer;
import net.serenitybdd.integration.utils.ListFunctions;
import net.serenitybdd.integration.utils.RuleChains;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JenkinsInstance
implements TestRule {
    private Path jenkinsHome = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private int portNumber = 8080;
    private JenkinsClient client = null;
    private List<ApplicativeTestRule<JenkinsInstance>> customRulesToApplyBeforeStart = new ArrayList<ApplicativeTestRule<JenkinsInstance>>();
    private List<ApplicativeTestRule<JenkinsInstance>> defaultRules;
    private List<ApplicativeTestRule<JenkinsInstance>> customRulesToApplyAfterStart = new ArrayList<ApplicativeTestRule<JenkinsInstance>>();

    public JenkinsInstance(Collection<PluginDescription> descriptions) {
        this.defaultRules = new ArrayList<ApplicativeTestRule<JenkinsInstance>>();
        for (PluginDescription description : descriptions) {
            this.defaultRules.add(InstallPlugins.fromDisk(description.path()));
        }
        this.defaultRules.add(new ManageJenkinsServer());
    }

    public String version() {
        return System.getProperty("jenkins.version");
    }

    public Path home() {
        return this.jenkinsHome;
    }

    public void setHome(Path jenkinsHome) {
        this.jenkinsHome = jenkinsHome;
    }

    public JenkinsClient client() {
        return this.client;
    }

    public void setClient(JenkinsClient client) {
        this.client = client;
    }

    public URL url() {
        try {
            return new URL(String.format("http://localhost:%d/", this.portNumber));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Couldn't instantiate a URL as 'http://localhost:%d/'", this.portNumber));
        }
    }

    public int port() {
        return this.portNumber;
    }

    public void setPort(int portNumber) {
        this.portNumber = portNumber;
    }

    public <ATR extends ApplicativeTestRule<JenkinsInstance>> JenkinsInstance beforeStartApply(List<ATR> customRulesToBeApplied) {
        this.customRulesToApplyBeforeStart = List.copyOf(customRulesToBeApplied);
        return this;
    }

    public <ATR extends ApplicativeTestRule<JenkinsInstance>> JenkinsInstance afterStartApply(List<ATR> customRulesToBeApplied) {
        this.customRulesToApplyAfterStart = List.copyOf(customRulesToBeApplied);
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return this.chainOf(ListFunctions.concat(this.customRulesToApplyBeforeStart, this.defaultRules, this.customRulesToApplyAfterStart)).apply(base, description);
    }

    private <ATR extends ApplicativeTestRule<JenkinsInstance>> RuleChain chainOf(List<ATR> rules) {
        return RuleChains.chained(this.instantiated(rules));
    }

    private <ATR extends ApplicativeTestRule<JenkinsInstance>> List<TestRule> instantiated(List<ATR> rules) {
        ArrayList<TestRule> instantiatedRules = new ArrayList<TestRule>(rules.size());
        for (ApplicativeTestRule testRule : rules) {
            instantiatedRules.add(testRule.applyTo(this));
        }
        return instantiatedRules;
    }
}

