/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions;

import hudson.Util;
import hudson.model.Run;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.RuleConfiguration;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions.Condition;

public class BuildDescriptionCondition
extends Condition {
    private String pattern;
    private MatchingMethodType matchingMethod = MatchingMethodType.EQUALS;

    @DataBoundConstructor
    public BuildDescriptionCondition() {
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = Util.fixNull((String)pattern);
    }

    public String getMatchingMethod() {
        return this.matchingMethod.name();
    }

    @DataBoundSetter
    public void setMatchingMethod(String matchingMethod) {
        this.matchingMethod = MatchingMethodType.valueOf(matchingMethod);
    }

    @Override
    public boolean matches(Run<?, ?> run, RuleConfiguration configuration) {
        String buildDescription = Util.fixNull((String)run.getDescription());
        switch (this.matchingMethod) {
            case CONTAINS: {
                return buildDescription.contains(this.pattern);
            }
            case MATCHES: {
                return buildDescription.matches(this.pattern);
            }
        }
        return buildDescription.equals(this.pattern);
    }

    public static enum MatchingMethodType {
        EQUALS,
        CONTAINS,
        MATCHES;

    }
}

