/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import hudson.security.ACL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader2;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public abstract class MACLPChoiceParameterDefinitionBase
extends ChoiceParameterDefinition {
    private String url;
    private String repository;
    private String credentialsId;
    private boolean reverseOrder;
    private static final Logger LOGGER = Logger.getLogger(MACLPChoiceParameterDefinitionBase.class.getName());

    public MACLPChoiceParameterDefinitionBase(String name, String[] choices, String description, String url, String repository, String credentialsId, boolean reverseOrder) {
        super(name, choices, description);
        this.url = url;
        this.repository = repository;
        this.credentialsId = credentialsId;
        this.reverseOrder = reverseOrder;
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getRepository() {
        return this.repository;
    }

    @DataBoundSetter
    public void setRepository(String repository) {
        this.repository = repository;
    }

    public List<String> getChoices() {
        LOGGER.log(Level.FINE, "getChoices");
        Item item = null;
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null) {
            item = (Item)req.findAncestorObject(Item.class);
        }
        List<String> retVal = Collections.emptyList();
        if (StringUtils.isEmpty((String)this.getUrl())) {
            LOGGER.log(Level.FINE, "not properly initialized. URL is empty.");
            retVal = new ArrayList();
            retVal.add("Job configuration has been changed manually. Please re-run the job to re-initiated this field.");
            return retVal;
        }
        IVersionReader2 serviceInstances = this.createServiceInstance(this.getUrl());
        if (StringUtils.isNotEmpty((String)this.getCredentialsId())) {
            LOGGER.log(Level.FINE, "try to get credentials: " + this.getCredentialsId());
            UsernamePasswordCredentialsImpl c = (UsernamePasswordCredentialsImpl)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(UsernamePasswordCredentialsImpl.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.getCredentialsId())}));
            if (c != null) {
                serviceInstances.setCredentials(c.getUsername(), c.getPassword().getPlainText());
            } else {
                LOGGER.log(Level.WARNING, "unable to find usernamepassword credentials with id: " + this.getCredentialsId() + ". continue without");
            }
        }
        try {
            MultivaluedMap<String, String> params = this.createBaseParameterList();
            params.putAll(this.createParameterList());
            LOGGER.log(Level.FINE, "call the service");
            retVal = serviceInstances.retrieveVersions(params);
            if (this.reverseOrder) {
                LOGGER.log(Level.FINE, "reverse order");
                Collections.reverse(retVal);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return retVal;
    }

    public boolean isValid(ParameterValue value) {
        return true;
    }

    protected MultivaluedMap<String, String> createBaseParameterList() {
        MultivaluedHashMap retVal = new MultivaluedHashMap();
        return retVal;
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        LOGGER.log(Level.FINE, "createValue " + jo.toString());
        return super.createValue(req, jo);
    }

    public StringParameterValue createValue(String value) {
        LOGGER.log(Level.FINE, "createValue " + value);
        return super.createValue(value);
    }

    protected abstract IVersionReader2 createServiceInstance(String var1);

    protected abstract MultivaluedMap<String, String> createParameterList();

    public int hashCode() {
        if (MACLPChoiceParameterDefinitionBase.class != ((Object)((Object)this)).getClass()) {
            return super.hashCode();
        }
        return Objects.hash(this.getName(), this.getDescription(), this.url, this.repository, this.credentialsId);
    }

    @SuppressFBWarnings(value={"EQ_GETCLASS_AND_CLASS_CONSTANT"}, justification="ParameterDefinitionTest tests that subclasses are not equal to their parent classes, so the behavior appears to be intentional")
    public boolean equals(Object obj) {
        if (MACLPChoiceParameterDefinitionBase.class != ((Object)((Object)this)).getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MACLPChoiceParameterDefinitionBase other = (MACLPChoiceParameterDefinitionBase)((Object)obj);
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.url, other.getUrl())) {
            return false;
        }
        if (!Objects.equals(this.repository, other.getRepository())) {
            return false;
        }
        return Objects.equals(this.credentialsId, other.credentialsId);
    }
}

