/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus.AbstractArtifactURLBuilder;

public class NexusContentServiceArtifactURLBuilder
extends AbstractArtifactURLBuilder {
    private static final String ENCODING = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(NexusContentServiceArtifactURLBuilder.class.getName());
    static final String SERVICE_URI = "service/local/artifact/maven/content?";
    static final String AMPERSAND = "&";

    @Override
    public String build(boolean pOnlyBaseURL) {
        StringBuilder retVal = new StringBuilder();
        retVal.append(this.getNexusURL());
        retVal.append(SERVICE_URI);
        retVal.append("r=").append(this.getRepositoryId()).append(AMPERSAND);
        retVal.append("g=").append(this.getGroupId()).append(AMPERSAND);
        retVal.append("a=").append(this.getArtifactId()).append(AMPERSAND);
        if (this.getPackaging() != null) {
            retVal.append("p=").append(this.getPackaging()).append(AMPERSAND);
        }
        if (this.getClassifier() != null) {
            retVal.append("c=").append(this.getClassifier()).append(AMPERSAND);
        }
        if (this.getVersion() != null) {
            retVal.append("v=").append(this.encode(this.getVersion()));
        }
        return retVal.toString();
    }

    String encode(String pValue) {
        try {
            String retVal = URLEncoder.encode(pValue, ENCODING);
            return retVal;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.FINE, "failed to convert version to  UTF-8:" + pValue);
            return pValue;
        }
    }
}

