/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning.impl;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.FilePath;
import hudson.util.IOException2;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.CryptoConfidentialKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.FileItem;
import org.jenkinsci.plugins.androidsigning.KeystoreCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class KeystoreCredentialsImpl
extends BaseStandardCredentials
implements KeystoreCredentials {
    private static final CryptoConfidentialKey KEY = new CryptoConfidentialKey(KeystoreCredentialsImpl.class.getName());
    @Nonnull
    private final Secret passphrase;
    @Nonnull
    private final String fileName;
    @Nonnull
    private final byte[] data;

    @DataBoundConstructor
    public KeystoreCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @Nonnull FileItem file, @CheckForNull String fileName, @CheckForNull String data, @CheckForNull String passphrase) throws IOException {
        super(scope, id, description);
        String name = file.getName();
        if (name.length() > 0) {
            this.fileName = name.replaceFirst("^.+[/\\\\]", "");
            byte[] unencrypted = file.get();
            try {
                this.data = KEY.encrypt().doFinal(unencrypted);
            }
            catch (GeneralSecurityException x) {
                throw new IOException2((Throwable)x);
            }
        } else {
            this.fileName = fileName;
            this.data = Base64.decodeBase64((String)data);
        }
        this.passphrase = Secret.fromString((String)passphrase);
    }

    public FilePath makeTempPath(FilePath path) throws IOException, InterruptedException {
        FilePath tmp = path.createTempFile("keystore", null);
        OutputStream out = tmp.write();
        out.write(this.unencrypted());
        out.close();
        return tmp;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.unencrypted());
    }

    public Secret getPassphrase() {
        return this.passphrase;
    }

    private byte[] unencrypted() throws IOException {
        try {
            return KEY.decrypt().doFinal(this.data);
        }
        catch (GeneralSecurityException x) {
            throw new IOException2((Throwable)x);
        }
    }
}

