/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import java.util.Objects;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class CacheKey {
    private final String username;
    private final String salt;
    private final String passwordHash;

    public CacheKey(String username, String salt, String passwordHash) {
        this.username = username;
        this.salt = salt;
        this.passwordHash = passwordHash;
    }

    public CacheKey(String username) {
        this.username = username;
        this.salt = null;
        this.passwordHash = null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return this.username.equals(cacheKey.username) && Objects.equals(this.salt, cacheKey.salt) && Objects.equals(this.passwordHash, cacheKey.passwordHash);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.salt, this.passwordHash);
    }
}

