/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.plugins.createjobadvanced.AbstractConfigurer;
import hudson.plugins.createjobadvanced.CreateJobAdvancedPlugin;
import hudson.plugins.createjobadvanced.FolderConfigurer;
import hudson.plugins.createjobadvanced.JobConfigurer;
import hudson.plugins.createjobadvanced.MavenConfigurer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class ItemListenerImpl
extends ItemListener {
    private static final Logger log = Logger.getLogger(CreateJobAdvancedPlugin.class.getName());
    private final List<AbstractConfigurer<?, ?>> configurers = new ArrayList();

    public ItemListenerImpl() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (null != instance) {
            if (null != instance.getPlugin("maven-plugin")) {
                MavenConfigurer mavenConfigurer = new MavenConfigurer();
                log.finer(mavenConfigurer.toString());
                this.configurers.add(mavenConfigurer);
            } else {
                JobConfigurer jobConfigurer = new JobConfigurer();
                log.finer(jobConfigurer.toString());
                this.configurers.add(jobConfigurer);
            }
            if (null != instance.getPlugin("cloudbees-folder")) {
                FolderConfigurer folderConfigurer = new FolderConfigurer();
                log.finer(folderConfigurer.toString());
                this.configurers.add(folderConfigurer);
            }
        }
    }

    public void onRenamed(Item item, String oldName, String newName) {
        Object[] params = new Object[]{oldName, newName};
        log.entering(((Object)((Object)this)).getClass().getSimpleName(), "onRenamed", params);
        for (AbstractConfigurer<?, ?> configurer : this.configurers) {
            boolean isRespCommitted = false;
            try {
                StaplerResponse2 rsp;
                String name = configurer.doRename(item);
                if (newName.compareTo(name) == 0 || null == (rsp = Stapler.getCurrentResponse2())) continue;
                isRespCommitted = rsp.isCommitted();
                rsp.sendRedirect2("../" + name);
            }
            catch (IllegalStateException e) {
                log.log(Level.FINEST, "resp.isCommitted()={0}", isRespCommitted);
                if (isRespCommitted) continue;
                log.log(Level.SEVERE, "error during sendRedirect2", e);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "error during sendRedirect2", e);
            }
        }
        log.exiting(((Object)((Object)this)).getClass().getSimpleName(), "onRenamed");
    }

    public void onCreated(Item item) {
        for (AbstractConfigurer<?, ?> configurer : this.configurers) {
            configurer.doCreate(item);
        }
    }

    protected List<AbstractConfigurer<?, ?>> getConfigurers() {
        return this.configurers;
    }
}

