/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SubversionHack;
import hudson.scm.SubversionSCM;
import hudson.scm.SvnClientManager;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jedi.functional.FunctionalPrimitives;
import jedi.functional.Functor;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import ru.yandex.jenkins.plugins.debuilder.DebUtils;
import ru.yandex.jenkins.plugins.debuilder.DebianBadge;
import ru.yandex.jenkins.plugins.debuilder.DebianPackagePublisher;
import ru.yandex.jenkins.plugins.debuilder.DebianizingException;
import ru.yandex.jenkins.plugins.debuilder.VersionHelper;

public class DebianPackageBuilder
extends Builder {
    public static final String DEBIAN_SOURCE_PACKAGE = "DEBIAN_SOURCE_PACKAGE";
    public static final String DEBIAN_PACKAGE_VERSION = "DEBIAN_PACKAGE_VERSION";
    public static final String ABORT_MESSAGE = "[{0}] Aborting: {1} ";
    private static final String PREFIX = "debian-package-builder";
    private final String pathToDebian;
    private final boolean generateChangelog;
    private final boolean buildEvenWhenThereAreNoChanges;

    @DataBoundConstructor
    public DebianPackageBuilder(String pathToDebian, Boolean generateChangelog, Boolean buildEvenWhenThereAreNoChanges) {
        this.pathToDebian = pathToDebian;
        this.generateChangelog = generateChangelog;
        this.buildEvenWhenThereAreNoChanges = buildEvenWhenThereAreNoChanges;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        FilePath workspace = build.getWorkspace();
        String remoteDebian = this.getRemoteDebian(workspace);
        DebUtils.Runner runner = new DebUtils.Runner(build, launcher, listener, PREFIX);
        try {
            runner.runCommand("sudo apt-get -y update");
            runner.runCommand("sudo apt-get -y install aptitude pbuilder");
            this.importKeys(workspace, runner);
            Map<String, String> changelog = this.parseChangelog(runner, remoteDebian);
            String source = changelog.get("Source");
            String latestVersion = changelog.get("Version");
            runner.announce("Determined latest version to be {0}", latestVersion);
            if (this.generateChangelog) {
                Pair<VersionHelper, List<Change>> changes = this.generateChangelog(latestVersion, runner, build, launcher, listener, remoteDebian);
                if (this.isTriggeredAutomatically(build) && ((List)changes.getRight()).isEmpty() && !this.buildEvenWhenThereAreNoChanges) {
                    runner.announce("There are no creditable changes for this build - not building package.");
                    return true;
                }
                latestVersion = ((VersionHelper)changes.getLeft()).toString();
                this.writeChangelog(build, listener, remoteDebian, runner, changes);
            }
            runner.runCommand("cd ''{0}'' && sudo /usr/lib/pbuilder/pbuilder-satisfydepends --control control", remoteDebian);
            runner.runCommand("cd ''{0}'' && debuild --check-dirname-level 0 --no-tgz-check -k{1} -p''gpg --no-tty --passphrase {2}''", remoteDebian, this.getDescriptor().getAccountName(), this.getDescriptor().getPassphrase());
            this.archiveArtifacts(build, runner, latestVersion);
            build.addAction((Action)new DebianBadge(latestVersion, remoteDebian));
            EnvVars envVars = new EnvVars(new String[]{DEBIAN_SOURCE_PACKAGE, source, DEBIAN_PACKAGE_VERSION, latestVersion});
            build.getEnvironments().add((Object)Environment.create((EnvVars)envVars));
        }
        catch (InterruptedException e) {
            logger.println(MessageFormat.format(ABORT_MESSAGE, PREFIX, e.getMessage()));
            return false;
        }
        catch (DebianizingException e) {
            logger.println(MessageFormat.format(ABORT_MESSAGE, PREFIX, e.getMessage()));
            return false;
        }
        catch (IOException e) {
            logger.println(MessageFormat.format(ABORT_MESSAGE, PREFIX, e.getMessage()));
            return false;
        }
        return true;
    }

    private void archiveArtifacts(AbstractBuild build, DebUtils.Runner runner, String latestVersion) throws IOException, InterruptedException {
        FilePath path = build.getWorkspace().child(this.pathToDebian).child("..");
        String mask = "*" + latestVersion + "*.deb";
        for (FilePath file : path.list(mask)) {
            runner.announce("Archiving file <{0}> as a build artifact", file.getName());
        }
        path.copyRecursiveTo(mask, new FilePath(build.getArtifactsDir()));
    }

    public String getRemoteDebian(FilePath workspace) {
        if (this.pathToDebian.endsWith("debian") || this.pathToDebian.endsWith("debian/")) {
            return workspace.child(this.pathToDebian).getRemote();
        }
        return workspace.child(this.pathToDebian).child("debian").getRemote();
    }

    private Pair<VersionHelper, List<Change>> generateChangelog(String latestVersion, DebUtils.Runner runner, AbstractBuild build, Launcher launcher, BuildListener listener, String remoteDebian) throws DebianizingException, InterruptedException, IOException {
        List<Change> changes;
        VersionHelper helper = new VersionHelper(latestVersion);
        runner.announce("Determined latest revision to be {0}", helper.getRevision());
        SCM scm = build.getProject().getScm();
        helper.setMinorVersion(helper.getMinorVersion() + 1);
        String oldRevision = helper.getRevision();
        String ourMessage = DebianPackagePublisher.getUsedCommitMessage(build);
        if (!(scm instanceof SubversionSCM)) {
            runner.announce("SCM in use is not Subversion (but <{0}> instead), defaulting to changes since last build", scm.getClass().getName());
            changes = this.getChangesSinceLastBuild(runner, build, ourMessage);
        } else {
            helper.setRevision(this.getSVNRevision(build, (SubversionSCM)scm, runner, remoteDebian, (TaskListener)listener));
            if ("".equals(oldRevision)) {
                runner.announce("No last revision known, using changes since last successful build to populate debian/changelog");
                changes = this.getChangesSinceLastBuild(runner, build, ourMessage);
            } else {
                runner.announce("Calculating changes since revision {0}.", oldRevision);
                changes = this.getChangesFromSubversion(runner, (SubversionSCM)scm, build, remoteDebian, oldRevision, helper.getRevision(), ourMessage);
            }
        }
        return new ImmutablePair((Object)helper, changes);
    }

    private void writeChangelog(AbstractBuild build, BuildListener listener, String remoteDebian, DebUtils.Runner runner, Pair<VersionHelper, List<Change>> changes) throws IOException, InterruptedException, DebianizingException {
        String versionMessage = this.getCausedMessage(build);
        String newVersionMessage = Util.replaceMacro((String)versionMessage, (VariableResolver)new VariableResolver.ByMap((Map)build.getEnvironment((TaskListener)listener)));
        this.startVersion(runner, remoteDebian, (VersionHelper)changes.getLeft(), newVersionMessage);
        for (Change change : (List)changes.getRight()) {
            this.addChange(runner, remoteDebian, change);
        }
    }

    private boolean isTriggeredAutomatically(AbstractBuild build) {
        for (Object cause : build.getCauses()) {
            if (!(cause instanceof Cause.UserIdCause)) continue;
            return false;
        }
        return true;
    }

    private String getCausedMessage(AbstractBuild build) {
        String firstPart = "Build #${BUILD_NUMBER}. ";
        List causes = build.getCauses();
        List causeMessages = FunctionalPrimitives.map((List)causes, (Functor)new Functor<Cause, String>(){

            public String execute(Cause value) {
                return value.getShortDescription();
            }
        });
        HashSet uniqueCauses = new HashSet(causeMessages);
        return firstPart + FunctionalPrimitives.join(uniqueCauses, (String)". ") + ".";
    }

    private String getSVNRevision(AbstractBuild build, SubversionSCM scm, DebUtils.Runner runner, String remoteDebian, TaskListener listener) throws DebianizingException {
        SubversionSCM.ModuleLocation location = this.findOurLocation(build, scm, runner, remoteDebian);
        try {
            Map<String, Long> revisionsForBuild = SubversionHack.getRevisionsForBuild(scm, build);
            return Long.toString(revisionsForBuild.get(location.getSVNURL().toString()));
        }
        catch (IOException e) {
            throw new DebianizingException("IOException: " + e.getMessage(), e);
        }
        catch (SVNException e) {
            throw new DebianizingException("SVNException: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new DebianizingException("InterruptedException: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new DebianizingException("IllegalArgumentException: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new DebianizingException("IllegalAccessException: " + e.getMessage(), e);
        }
    }

    private SubversionSCM.ModuleLocation findOurLocation(AbstractBuild build, SubversionSCM scm, DebUtils.Runner runner, String remoteDebian) throws DebianizingException {
        for (SubversionSCM.ModuleLocation location : scm.getLocations()) {
            try {
                SubversionSCM.ModuleLocation expandedLocation = location.getExpandedLocation(build.getEnvironment((TaskListener)runner.getListener()));
                String moduleDir = expandedLocation.getLocalDir();
                if (!remoteDebian.startsWith(build.getWorkspace().child(moduleDir).getRemote())) continue;
                return expandedLocation;
            }
            catch (IOException e) {
                throw new DebianizingException("IOException: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new DebianizingException("InterruptedException: " + e.getMessage(), e);
            }
        }
        throw new DebianizingException("Can't find module location for remoteDebian " + remoteDebian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Change> getChangesFromSubversion(DebUtils.Runner runner, SubversionSCM scm, AbstractBuild build, String remoteDebian, String latestRevision, String currentRevision, final String ourMessage) throws DebianizingException {
        final ArrayList<Change> result = new ArrayList<Change>();
        SvnClientManager manager = SubversionSCM.createClientManager((AbstractProject)build.getProject());
        try {
            SubversionSCM.ModuleLocation location = this.findOurLocation(build, scm, runner, remoteDebian);
            try {
                SVNURL svnurl = location.getSVNURL();
                manager.getLogClient().doLog(svnurl, null, SVNRevision.UNDEFINED, SVNRevision.create((long)(Long.parseLong(latestRevision) + 1L)), SVNRevision.parse((String)currentRevision), false, true, 0L, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                        if (!logEntry.getMessage().equals(ourMessage)) {
                            result.add(new Change(logEntry.getAuthor(), logEntry.getMessage()));
                        }
                    }
                });
            }
            catch (SVNException e) {
                throw new DebianizingException("SVNException: " + e.getMessage(), e);
            }
        }
        finally {
            manager.dispose();
        }
        return result;
    }

    private List<Change> getChangesSinceLastBuild(DebUtils.Runner runner, AbstractBuild build, String ourMessage) throws InterruptedException, DebianizingException {
        ArrayList<Change> result = new ArrayList<Change>();
        Run lastSuccessfulBuild = build.getProject().getLastSuccessfulBuild();
        int lastSuccessNumber = lastSuccessfulBuild == null ? 0 : lastSuccessfulBuild.number;
        for (int num = lastSuccessNumber + 1; num <= build.number; ++num) {
            AbstractBuild run = build.getProject().getBuildByNumber(num);
            if (run == null) continue;
            ChangeLogSet changeSet = run.getChangeSet();
            for (ChangeLogSet.Entry entry : changeSet) {
                if (entry.getMsg().equals(ourMessage)) continue;
                result.add(new Change(entry.getAuthor().getFullName(), entry.getMsg()));
            }
        }
        return result;
    }

    private String clearMessage(String message) {
        return message.replaceAll("\\'", "");
    }

    private void addChange(DebUtils.Runner runner, String remoteDebian, Change change) throws InterruptedException, DebianizingException {
        runner.announce("Got changeset entry: {0} by {1}", this.clearMessage(change.getMessage()), change.getAuthor());
        runner.runCommand("export DEBEMAIL={0} && export DEBFULLNAME={1} && cd ''{2}'' && dch --check-dirname-level 0 --distributor debian --append ''{3}''", this.getDescriptor().getAccountName(), change.getAuthor(), remoteDebian, this.clearMessage(change.getMessage()));
    }

    private void startVersion(DebUtils.Runner runner, String remoteDebian, VersionHelper helper, String message) throws InterruptedException, DebianizingException {
        runner.announce("Starting version <{0}> with message <{1}>", helper, this.clearMessage(message));
        runner.runCommand("export DEBEMAIL={0} && export DEBFULLNAME={1} && cd ''{2}'' && dch --check-dirname-level 0 -b --distributor debian --newVersion {3} ''{4}''", this.getDescriptor().getAccountName(), "Jenkins", remoteDebian, helper, this.clearMessage(message));
    }

    private Map<String, String> parseChangelog(DebUtils.Runner runner, String remoteDebian) throws DebianizingException {
        String changelogOutput = runner.runCommandForOutput("cd \"{0}\" && dpkg-parsechangelog -lchangelog", remoteDebian);
        HashMap<String, String> changelog = new HashMap<String, String>();
        Pattern changelogFormat = Pattern.compile("(\\w+):\\s*(.*)");
        for (String row : changelogOutput.split("\n")) {
            Matcher matcher = changelogFormat.matcher(row);
            if (!matcher.matches()) continue;
            changelog.put(matcher.group(1), matcher.group(2));
        }
        return changelog;
    }

    private void importKeys(FilePath workspace, DebUtils.Runner runner) throws InterruptedException, DebianizingException, IOException {
        if (!runner.runCommandForResult("gpg --list-key {0}", this.getDescriptor().getAccountName())) {
            FilePath publicKey = workspace.createTextTempFile("public", "key", this.getDescriptor().getPublicKey());
            runner.runCommand("gpg --import ''{0}''", publicKey.getRemote());
            publicKey.delete();
        }
        if (!runner.runCommandForResult("gpg --list-secret-key {0}", this.getDescriptor().getAccountName())) {
            FilePath privateKey = workspace.createTextTempFile("private", "key", this.getDescriptor().getPrivateKey());
            runner.runCommand("gpg --import ''{0}''", privateKey.getRemote());
            privateKey.delete();
        }
    }

    public boolean isGenerateChangelog() {
        return this.generateChangelog;
    }

    public String getPathToDebian() {
        return this.pathToDebian;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static Collection<String> getRemoteModules(AbstractBuild<?, ?> build) {
        ArrayList<String> result = new ArrayList<String>();
        for (DebianPackageBuilder builder : DebianPackageBuilder.getDPBuilders(build)) {
            result.add(new FilePath(build.getWorkspace().getChannel(), builder.getRemoteDebian(build.getWorkspace())).child("..").getRemote());
        }
        return result;
    }

    public static Collection<DebianPackageBuilder> getDPBuilders(AbstractBuild<?, ?> build) {
        ArrayList<DebianPackageBuilder> result = new ArrayList<DebianPackageBuilder>();
        if (build.getProject() instanceof Project) {
            DescribableList builders = ((Project)build.getProject()).getBuildersList();
            for (Builder builder : builders) {
                if (!(builder instanceof DebianPackageBuilder)) continue;
                result.add((DebianPackageBuilder)builder);
            }
        }
        return result;
    }

    public boolean isBuildEvenWhenThereAreNoChanges() {
        return this.buildEvenWhenThereAreNoChanges;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String publicKey;
        private String privateKey;
        private String accountName;
        private String passphrase;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Build debian package";
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.setPrivateKey(json.getString("privateKey"));
            this.setPublicKey(json.getString("publicKey"));
            this.setAccountName(json.getString("accountName"));
            this.setPassphrase(json.getString("passphrase"));
            this.save();
            return true;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public void setPassphrase(String passphrase) {
            this.passphrase = passphrase;
        }
    }

    private static final class Change {
        private final String author;
        private final String message;

        public Change(String author, String message) {
            this.author = author;
            this.message = message;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

