/*
 * Decompiled with CFR 0.152.
 */
package ren.helloworld.upload2pgyer.java;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import ren.helloworld.upload2pgyer.java.Message;
import ren.helloworld.upload2pgyer.java.PgyerBean;
import ren.helloworld.upload2pgyer.java.UploadBean;

public class UploadPgyer {
    private static final String TAG = "[UPLOAD TO PGYER] - ";
    private static final String UPLOAD_URL = "https://qiniu-storage.pgyer.com/apiv1/app/upload";

    public static void main(String[] args) {
        Message listener = new Message(){

            @Override
            public void message(boolean needTag, String mesage) {
                System.out.println((needTag ? UploadPgyer.TAG : "") + mesage);
            }
        };
        UploadPgyer.printHeaderInfo(listener);
        UploadBean uploadBean = UploadPgyer.parseArgs(args, listener);
        if (uploadBean == null) {
            return;
        }
        UploadPgyer.upload2Pgyer(false, uploadBean, listener);
    }

    private static UploadBean parseArgs(String[] args, Message listener) {
        int length = args.length;
        if (length == 0 || length % 2 != 0) {
            UploadPgyer.printMessage(listener, true, "args length is error!\n");
            return null;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            maps.put(args[i], args[i + 1]);
        }
        if (!maps.containsKey("-uKey")) {
            UploadPgyer.printMessage(listener, true, "uKey not found!\n");
            return null;
        }
        if (!maps.containsKey("-apiKey")) {
            UploadPgyer.printMessage(listener, true, "apiKey not found!\n");
            return null;
        }
        if (!maps.containsKey("-scanDir")) {
            UploadPgyer.printMessage(listener, true, "scanDir not found!\n");
            return null;
        }
        if (!maps.containsKey("-wildcard")) {
            UploadPgyer.printMessage(listener, true, "wildcard not found!\n");
            return null;
        }
        UploadBean uploadBean = new UploadBean();
        uploadBean.setUkey((String)maps.get("-uKey"));
        uploadBean.setApiKey((String)maps.get("-apiKey"));
        uploadBean.setScandir((String)maps.get("-scanDir"));
        uploadBean.setWildcard((String)maps.get("-wildcard"));
        uploadBean.setPassword(maps.containsKey("-password") ? (String)maps.get("-password") : "");
        uploadBean.setQrcodePath(maps.containsKey("-qrcodePath") ? (String)maps.get("-qrcodePath") : null);
        uploadBean.setEnvVarsPath(maps.containsKey("-envVarsPath") ? (String)maps.get("-envVarsPath") : null);
        uploadBean.setInstallType(maps.containsKey("-installType") ? (String)maps.get("-installType") : "1");
        uploadBean.setUpdateDescription(maps.containsKey("-updateDescription") ? (String)maps.get("-updateDescription") : "");
        return uploadBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PgyerBean upload2Pgyer(boolean printHeader, UploadBean uploadBean, Message listener) {
        if (printHeader) {
            UploadPgyer.printHeaderInfo(listener);
        }
        uploadBean.setUploadFile(UploadPgyer.findFile(uploadBean, listener));
        if (uploadBean.getUploadFile() == null) {
            UploadPgyer.printMessage(listener, true, "upload file not found\uff0cplase check scandir or wildcard!\n");
            return null;
        }
        File uploadFile = new File(uploadBean.getUploadFile());
        if (!uploadFile.exists() || !uploadFile.isFile()) {
            UploadPgyer.printMessage(listener, true, "upload file not found\uff0cplase check scandir or wildcard!\n");
            return null;
        }
        String result = "";
        FileInputStream fis = null;
        try {
            UploadPgyer.printMessage(listener, true, "upload\uff1a" + uploadFile.getName() + " to " + UPLOAD_URL);
            fis = new FileInputStream(uploadFile);
            Document document = Jsoup.connect((String)UPLOAD_URL).ignoreContentType(true).data("uKey", uploadBean.getUkey()).data("_api_key", uploadBean.getApiKey()).data("installType", uploadBean.getInstallType()).data("password", uploadBean.getPassword()).data("updateDescription", uploadBean.getUpdateDescription()).data("file", uploadFile.getName(), (InputStream)fis).post();
            result = document.body().text();
            PgyerBean pgyerBean = (PgyerBean)new Gson().fromJson(result, new TypeToken<PgyerBean>(){}.getType());
            if (pgyerBean.getCode() != 0) {
                UploadPgyer.printMessage(listener, true, "upload to pgyer failure!");
                UploadPgyer.printMessage(listener, true, "error code\uff1a" + pgyerBean.getCode());
                UploadPgyer.printMessage(listener, true, "error message\uff1a" + pgyerBean.getMessage() + "\n");
                PgyerBean pgyerBean2 = null;
                return pgyerBean2;
            }
            pgyerBean.getData().setAppPgyerURL("https://www.pgyer.com/" + pgyerBean.getData().getAppShortcutUrl());
            pgyerBean.getData().setAppBuildURL("https://www.pgyer.com/" + pgyerBean.getData().getAppKey());
            UploadPgyer.printMessage(listener, true, "upload to pgyer success!\n");
            UploadPgyer.printResultInfo(pgyerBean, listener);
            UploadPgyer.writeEnvVars(uploadBean, pgyerBean, listener);
            UploadPgyer.downloadQrcode(uploadBean, pgyerBean, listener);
            PgyerBean pgyerBean3 = pgyerBean;
            return pgyerBean3;
        }
        catch (Exception e) {
            listener.message(true, "pgyer result: " + result);
            listener.message(true, "ERROR: " + e.getMessage() + "\n");
            PgyerBean pgyerBean = null;
            return pgyerBean;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String findFile(UploadBean bean, Message listener) {
        File dir = new File(bean.getScandir());
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            UploadPgyer.printMessage(listener, true, "scan dir:" + dir.getAbsolutePath());
            UploadPgyer.printMessage(listener, true, "scan dir isn't exist or it's not a directory!");
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(bean.getScandir());
        scanner.setIncludes(new String[]{bean.getWildcard()});
        scanner.setCaseSensitive(true);
        scanner.scan();
        String[] uploadFiles = scanner.getIncludedFiles();
        if (uploadFiles == null || uploadFiles.length == 0) {
            return null;
        }
        if (uploadFiles.length == 1) {
            return new File(dir, uploadFiles[0]).getAbsolutePath();
        }
        List<String> strings = Arrays.asList(uploadFiles);
        Collections.sort(strings, new FileComparator(dir));
        String uploadFiltPath = new File(dir, strings.get(0)).getAbsolutePath();
        UploadPgyer.printMessage(listener, true, "Found " + uploadFiles.length + " files, the default choice of the latest modified file!");
        UploadPgyer.printMessage(listener, true, "The latest modified file is " + uploadFiltPath + "\n");
        return uploadFiltPath;
    }

    private static void downloadQrcode(UploadBean uploadBean, PgyerBean pgyerBean, Message listener) {
        if (uploadBean.getQrcodePath() == null) {
            return;
        }
        if (UploadPgyer.replaceBlank(uploadBean.getQrcodePath()).length() == 0) {
            return;
        }
        UploadPgyer.printMessage(listener, true, "now download qrcode");
        File qrcode = new File(uploadBean.getQrcodePath());
        if (!qrcode.getParentFile().exists() && !qrcode.getParentFile().mkdirs()) {
            UploadPgyer.printMessage(listener, true, "orz..., download qrcode failure\u2026\u2026\n");
            return;
        }
        File file = UploadPgyer.download(pgyerBean.getData().getAppQRCodeURL(), qrcode.getParentFile().getAbsolutePath(), qrcode.getName());
        if (file != null) {
            UploadPgyer.printMessage(listener, true, "download qrcode success! " + file + "\n");
        } else {
            UploadPgyer.printMessage(listener, true, "orz..., download qrcode failure\u2026\u2026\n");
        }
    }

    private static void writeEnvVars(UploadBean uploadBean, PgyerBean pgyerBean, Message listener) {
        if (uploadBean.getEnvVarsPath() == null) {
            return;
        }
        if (UploadPgyer.replaceBlank(uploadBean.getEnvVarsPath()).length() == 0) {
            return;
        }
        UploadPgyer.printMessage(listener, true, "now write env vars to file\u2026\u2026");
        File envVars = new File(uploadBean.getEnvVarsPath());
        if (!envVars.getParentFile().exists() && !envVars.getParentFile().mkdirs()) {
            UploadPgyer.printMessage(listener, true, "orz..., write env vars to file failure\u2026\u2026\n");
            return;
        }
        File file = UploadPgyer.write(envVars.getAbsolutePath(), UploadPgyer.getEnvVarsInfo(pgyerBean), "utf-8");
        if (file != null) {
            UploadPgyer.printMessage(listener, true, "write env vars to file success! " + file + "\n");
        } else {
            UploadPgyer.printMessage(listener, true, "orz..., write env vars to file failure\u2026\u2026\n");
        }
    }

    private static File write(String path, String content, String encoding) {
        try {
            File file = new File(path);
            if (!file.delete() && !file.createNewFile()) {
                return null;
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            writer.write(content);
            writer.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File download(String urlString, String savePath, String fileName) {
        InputStream is = null;
        OutputStream os = null;
        try {
            int len;
            File dir = new File(savePath);
            if (!dir.exists() && !dir.mkdirs()) {
                File file = null;
                return file;
            }
            String filePath = savePath + File.separator + fileName;
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(60000);
            is = con.getInputStream();
            byte[] bs = new byte[8192];
            os = new FileOutputStream(filePath);
            while ((len = is.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
            File file = new File(filePath);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void printResultInfo(PgyerBean pgyerBean, Message listener) {
        PgyerBean.DataBean data = pgyerBean.getData();
        UploadPgyer.printMessage(listener, true, "App Key\uff1a" + data.getAppKey());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u7c7b\u578b\uff1a" + data.getAppType());
        UploadPgyer.printMessage(listener, true, "\u662f\u5426\u662f\u6700\u65b0\u7248\uff1a" + data.getAppIsLastest());
        UploadPgyer.printMessage(listener, true, "App \u6587\u4ef6\u5927\u5c0f\uff1a" + data.getAppFileSize());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u540d\u79f0\uff1a" + data.getAppName());
        UploadPgyer.printMessage(listener, true, "\u7248\u672c\u53f7\uff1a" + data.getAppVersion());
        UploadPgyer.printMessage(listener, true, "Android\u7684\u7248\u672c\u7f16\u53f7\uff1a" + data.getAppVersionNo());
        UploadPgyer.printMessage(listener, true, "build\u53f7\uff1a" + data.getAppBuildVersion());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u7a0b\u5e8f\u5305\u540d\uff1a" + data.getAppIdentifier());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u7684Icon\u56fe\u6807key\uff1a" + data.getAppIcon());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u4ecb\u7ecd\uff1a" + data.getAppDescription());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u66f4\u65b0\u8bf4\u660e\uff1a" + data.getAppUpdateDescription());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u622a\u56fe\u7684key\uff1a" + data.getAppScreenshots());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u77ed\u94fe\u63a5\uff1a" + data.getAppShortcutUrl());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u4e8c\u7ef4\u7801\u5730\u5740\uff1a" + data.getAppQRCodeURL());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u4e0a\u4f20\u65f6\u95f4\uff1a" + data.getAppCreated());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u66f4\u65b0\u65f6\u95f4\uff1a" + data.getAppUpdated());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u4e3b\u9875\uff1a" + data.getAppPgyerURL());
        UploadPgyer.printMessage(listener, true, "\u5e94\u7528\u6784\u5efa\u4e3b\u9875\uff1a" + data.getAppBuildURL());
        UploadPgyer.printMessage(listener, false, "");
    }

    private static String getEnvVarsInfo(PgyerBean pgyerBean) {
        StringBuffer sb = new StringBuffer();
        sb.append("appKey").append("=").append(pgyerBean.getData().getAppKey()).append("\n");
        sb.append("appType").append("=").append(pgyerBean.getData().getAppType()).append("\n");
        sb.append("appIsLastest").append("=").append(pgyerBean.getData().getAppIsLastest()).append("\n");
        sb.append("appFileSize").append("=").append(pgyerBean.getData().getAppFileSize()).append("\n");
        sb.append("appName").append("=").append(pgyerBean.getData().getAppName()).append("\n");
        sb.append("appVersion").append("=").append(pgyerBean.getData().getAppVersion()).append("\n");
        sb.append("appVersionNo").append("=").append(pgyerBean.getData().getAppVersionNo()).append("\n");
        sb.append("appBuildVersion").append("=").append(pgyerBean.getData().getAppBuildVersion()).append("\n");
        sb.append("appIdentifier").append("=").append(pgyerBean.getData().getAppIdentifier()).append("\n");
        sb.append("appIcon").append("=").append(pgyerBean.getData().getAppIcon()).append("\n");
        sb.append("appDescription").append("=").append(pgyerBean.getData().getAppDescription()).append("\n");
        sb.append("appUpdateDescription").append("=").append(pgyerBean.getData().getAppUpdateDescription()).append("\n");
        sb.append("appScreenshots").append("=").append(pgyerBean.getData().getAppScreenshots()).append("\n");
        sb.append("appShortcutUrl").append("=").append(pgyerBean.getData().getAppShortcutUrl()).append("\n");
        sb.append("appCreated").append("=").append(pgyerBean.getData().getAppCreated()).append("\n");
        sb.append("appUpdated").append("=").append(pgyerBean.getData().getAppUpdated()).append("\n");
        sb.append("appQRCodeURL").append("=").append(pgyerBean.getData().getAppQRCodeURL()).append("\n");
        sb.append("appPgyerURL").append("=").append(pgyerBean.getData().getAppPgyerURL()).append("\n");
        sb.append("appBuildURL").append("=").append(pgyerBean.getData().getAppBuildURL()).append("\n");
        return sb.toString();
    }

    private static void printHeaderInfo(Message listener) {
        UploadPgyer.printMessage(listener, false, "");
        UploadPgyer.printMessage(listener, false, "**************************************************************************************************");
        UploadPgyer.printMessage(listener, false, "**************************************************************************************************");
        UploadPgyer.printMessage(listener, false, "********************************          UPLOAD TO PGYER         ********************************");
        UploadPgyer.printMessage(listener, false, "**************************************************************************************************");
        UploadPgyer.printMessage(listener, false, "**************************************************************************************************\n");
    }

    private static void printMessage(Message listener, boolean needTag, String message) {
        if (listener == null) {
            return;
        }
        listener.message(needTag, message);
    }

    private static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    private static class FileComparator
    implements Comparator<String>,
    Serializable {
        File dir;

        public FileComparator(File dir) {
            this.dir = dir;
        }

        @Override
        public int compare(String o1, String o2) {
            File file1 = new File(this.dir, o1);
            File file2 = new File(this.dir, o2);
            if (file1.lastModified() < file2.lastModified()) {
                return 1;
            }
            if (file1.lastModified() > file2.lastModified()) {
                return -1;
            }
            return 0;
        }
    }
}

