/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeResponseUrl;
import com.google.api.client.auth.oauth2.Credential;
import hudson.EnvVars;
import hudson.remoting.Base64;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftHttpRedirectWithPrompt;

public abstract class OAuthSession
implements Serializable {
    private static final String OPENSHIFT_ENABLE_REDIRECT_PROMPT = "OPENSHIFT_ENABLE_REDIRECT_PROMPT";
    private final AuthorizationCodeFlow flow;
    private final String uuid = Base64.encode((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)).substring(0, 20);
    private final String from;
    private final String redirectUrl;
    private Credential credential;
    static final String SESSION_NAME = OAuthSession.class.getName();

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential cred) {
        this.credential = cred;
    }

    public OAuthSession(AuthorizationCodeFlow flow, String from, String redirectUrl) {
        this.flow = flow;
        this.from = from;
        this.redirectUrl = redirectUrl;
    }

    public HttpResponse doCommenceLogin() throws IOException {
        Stapler.getCurrentRequest().getSession().setAttribute(SESSION_NAME, (Object)this);
        return this.doRequestAuthorizationCode();
    }

    protected HttpResponse doRequestAuthorizationCode() {
        AuthorizationCodeRequestUrl authorizationCodeRequestUrl = this.flow.newAuthorizationUrl().setState(this.uuid).setRedirectUri(this.redirectUrl);
        String redirect = (String)EnvVars.masterEnvVars.get(OPENSHIFT_ENABLE_REDIRECT_PROMPT);
        if (redirect != null && !redirect.equalsIgnoreCase("false")) {
            return new OpenShiftHttpRedirectWithPrompt(authorizationCodeRequestUrl.toString());
        }
        return new HttpRedirect(authorizationCodeRequestUrl.toString());
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        StringBuffer buf = request.getRequestURL();
        if (request.getQueryString() != null) {
            buf.append('?').append(request.getQueryString());
        }
        AuthorizationCodeResponseUrl responseUrl = new AuthorizationCodeResponseUrl(buf.toString());
        String diagnosticPointer = ", see https://docs.openshift.org/latest/architecture/additional_concepts/authentication.html#api-events-oauth-clients for possible hints on how to diagnose problems in OpenShift that could cause this.";
        if (!this.uuid.equals(responseUrl.getState())) {
            return HttpResponses.error((int)401, (String)("State is invalid; uuid == " + this.uuid + " resp state == " + responseUrl.getState() + diagnosticPointer));
        }
        String code = responseUrl.getCode();
        if (responseUrl.getError() != null) {
            return HttpResponses.error((int)401, (String)("Error from provider: " + code + diagnosticPointer));
        }
        if (code == null) {
            return HttpResponses.error((int)404, (String)("Missing authorization code" + diagnosticPointer));
        }
        return this.onSuccess(code);
    }

    protected String getFrom() {
        return this.from;
    }

    protected abstract HttpResponse onSuccess(String var1) throws IOException;

    public static OAuthSession getCurrent() {
        return (OAuthSession)Stapler.getCurrentRequest().getSession().getAttribute(SESSION_NAME);
    }
}

