/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.maven;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.WebTarget;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractRESTfulVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.VersionReaderException;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.maven.MavenMetaData;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.maven.Version;

public class MavenMetadataSearchService
extends AbstractRESTfulVersionReader {
    private static final Logger LOGGER = Logger.getLogger(MavenMetadataSearchService.class.getName());
    private static final ThreadLocal<JAXBContext> JAXBCONTEXT = ThreadLocal.withInitial(() -> {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContext = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(MavenMetadataSearchService.class.getClassLoader());
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{MavenMetaData.class});
            return jAXBContext;
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "failed to init JAXB context", e);
            JAXBContext jAXBContext = null;
            return jAXBContext;
        }
        finally {
            currentThread.setContextClassLoader(originalContext);
        }
    });

    public MavenMetadataSearchService(String mURL) {
        super(mURL);
    }

    @Override
    @Deprecated
    public String getRESTfulServiceEndpoint() {
        return "";
    }

    @Override
    public Set<String> callService(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) throws VersionReaderException {
        LOGGER.info("Fetch maven");
        WebTarget theInstance = this.getInstance().path(pRepositoryId).path(pGroupId.replace(".", "/")).path(pArtifactId);
        String baseURL = theInstance.getUri().toString();
        theInstance = theInstance.path("maven-metadata.xml");
        LOGGER.info("Final URL: " + theInstance.getUri().toString());
        String response = (String)theInstance.request(new String[]{"application/xml"}).get(String.class);
        LOGGER.info("Received response. Parsing maven-metadata.xml of size: " + response.length());
        List<String> parseVersions = this.parseVersions(response);
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        for (String version : parseVersions) {
            retVal.add(baseURL + "/" + version);
        }
        return retVal;
    }

    List<String> parseVersions(String pResponse) throws VersionReaderException {
        ArrayList<String> retVal = new ArrayList<String>();
        MavenMetaData xmlResult = null;
        try {
            Unmarshaller unmarshaller = JAXBCONTEXT.get().createUnmarshaller();
            StringReader reader = new StringReader(pResponse);
            xmlResult = (MavenMetaData)unmarshaller.unmarshal((Reader)reader);
            if (xmlResult.getVersioning() != null) {
                for (Version current : xmlResult.getVersioning().getVersions()) {
                    retVal.add(current.getVersion());
                }
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "xml response: " + pResponse);
            }
            throw new VersionReaderException("Failed to parse XML response. Retrieved maven-metadata.xml seems to be invalid", e);
        }
        return retVal;
    }
}

