/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.artifactory;

import com.google.gson.Gson;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractRESTfulVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.artifactory.ArtifactoryResultEntryModel;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.artifactory.ArtifactoryResultModel;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus.StandardRESTfulParameterBuilder;

public class ArtifactorySearchService
extends AbstractRESTfulVersionReader {
    private static final Logger LOGGER = Logger.getLogger(ArtifactorySearchService.class.getName());
    private static final String SEARCH_SERVICE = "api/search/gavc";

    public ArtifactorySearchService(String pURL) {
        super(pURL);
    }

    @Override
    public String getRESTfulServiceEndpoint() {
        return SEARCH_SERVICE;
    }

    @Override
    public Set<String> callService(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) {
        MultivaluedMap<String, String> requestParams = new StandardRESTfulParameterBuilder().create("", pGroupId, pArtifactId, pPackaging, pClassifier);
        Set<String> retVal = new LinkedHashSet<String>();
        LOGGER.info("call artifactory service");
        WebTarget theInstance = this.getInstance();
        for (Map.Entry entries : requestParams.entrySet()) {
            theInstance = theInstance.queryParam((String)entries.getKey(), ((List)entries.getValue()).toArray());
        }
        String plainResult = (String)theInstance.request(new String[]{"application/json"}).get(String.class);
        if (plainResult == null) {
            LOGGER.info("response from Artifactory Service is NULL.");
        } else {
            LOGGER.info("parse result from artifactory service to JSON");
            retVal = this.parseResult(plainResult, pPackaging);
        }
        return retVal;
    }

    Set<String> parseResult(String pContent, String pPackaging) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        try {
            ArtifactoryResultModel fromJson = (ArtifactoryResultModel)new Gson().fromJson(pContent, ArtifactoryResultModel.class);
            for (ArtifactoryResultEntryModel current : fromJson.getResults()) {
                if (!this.validPackaging(current.getUri(), pPackaging)) continue;
                retVal.add(current.getUri());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "failed to parse JSON returned from ArtifactoryService: '" + pContent + "'", e);
        }
        return retVal;
    }

    private boolean validPackaging(String pArtifactURL, String pRequestedPackaging) {
        if (StringUtils.isEmpty((String)pRequestedPackaging.trim())) {
            return true;
        }
        return pArtifactURL.endsWith(pRequestedPackaging);
    }
}

