/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractRESTfulVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader2;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.VersionReaderException;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3.Nexus3RESTfulParameterBuilderForSearch;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3.Nexus3RestResponseSearch;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3.SearchItem;

public class Nexus3RestApiSearchService
extends AbstractRESTfulVersionReader
implements IVersionReader2 {
    private static final Logger LOGGER = Logger.getLogger(Nexus3RestApiSearchService.class.getName());
    public static final String PARAMETER_TOKEN = "continuationToken";
    private static final String NEXUS3_ASSET_REST_API_ENDPOINT = "service/rest/v1/search";
    private String imagePrefix;

    public Nexus3RestApiSearchService(String pURL) {
        this(pURL, null);
    }

    public Nexus3RestApiSearchService(String pURL, String pImagePrefix) {
        super(pURL);
        this.imagePrefix = pImagePrefix;
    }

    protected MultivaluedMap<String, String> createRequestParameters(String pRepository, String pGroup, String pName, String token) {
        return Nexus3RESTfulParameterBuilderForSearch.create(pRepository, pGroup, pName, token);
    }

    @Override
    @Deprecated
    public Set<String> callService(String pRepositoryId, String pGroup, String pName, String pPackaging, ValidAndInvalidClassifier pClassifier) {
        MultivaluedMap<String, String> requestParams = this.createRequestParameters(pRepositoryId, pGroup, pName, null);
        return this.callService(requestParams, pClassifier);
    }

    @Override
    public List<String> retrieveVersions(MultivaluedMap<String, String> pParams) throws VersionReaderException {
        return this.retrieveVersions(pParams, null);
    }

    @Override
    public List<String> retrieveVersions(MultivaluedMap<String, String> pParams, ValidAndInvalidClassifier pClassifier) throws VersionReaderException {
        Set<String> callService = this.callService(pParams, pClassifier);
        return callService.stream().collect(Collectors.toList());
    }

    protected Set<String> callService(MultivaluedMap<String, String> pParams, ValidAndInvalidClassifier pClassifier) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        String token = null;
        ObjectMapper mapper = new ObjectMapper();
        do {
            WebTarget theInstance = this.getInstance();
            pParams.putSingle((Object)PARAMETER_TOKEN, token);
            for (Map.Entry entries : pParams.entrySet()) {
                theInstance = theInstance.queryParam((String)entries.getKey(), ((List)entries.getValue()).toArray());
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("URI: " + String.valueOf(theInstance.getUri()));
            }
            String plainResult = (String)theInstance.request(new String[]{"application/json"}).get(String.class);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.info(plainResult);
            }
            try {
                Nexus3RestResponseSearch parsedJsonResult = (Nexus3RestResponseSearch)mapper.readValue(plainResult, Nexus3RestResponseSearch.class);
                if (parsedJsonResult == null) {
                    LOGGER.info("response from Nexus3 is NULL.");
                    continue;
                }
                if (parsedJsonResult.getItems().length == 0) {
                    LOGGER.info("response from Nexus3 does not contain any results.");
                    token = parsedJsonResult.getContinuationToken();
                    continue;
                }
                Set<String> currentResult = this.parseAndFilterResponse(parsedJsonResult);
                retVal.addAll(currentResult);
                token = parsedJsonResult.getContinuationToken();
            }
            catch (JsonParseException e) {
                LOGGER.log(Level.WARNING, "failed to parse", e);
            }
            catch (JsonMappingException e) {
                LOGGER.log(Level.WARNING, "failed to map", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "failed to ioexception", e);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "unexpected error", e);
            }
        } while (!StringUtils.isEmpty(token));
        return retVal;
    }

    Set<String> parseAndFilterResponse(Nexus3RestResponseSearch pJsonResult) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        boolean addItemToResult = true;
        for (SearchItem current : pJsonResult.getItems()) {
            if (!addItemToResult) continue;
            if (StringUtils.isEmpty((String)this.imagePrefix)) {
                retVal.add(current.getName() + ":" + current.getVersion());
                continue;
            }
            retVal.add(this.imagePrefix + current.getName() + ":" + current.getVersion());
        }
        return retVal;
    }

    @Override
    public String getRESTfulServiceEndpoint() {
        return NEXUS3_ASSET_REST_API_ENDPOINT;
    }
}

