/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3;

import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.AbstractMavenArtifactChoiceListProvider;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.MavenArtifactChoiceListProviderUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.VersionReaderException;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.nexus3.Nexus3RestApiAssetGenericService;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class Nexus3GenericChoiceListProvider
extends AbstractMavenArtifactChoiceListProvider {
    private static final long serialVersionUID = -5192115026547049358L;
    private static final Logger LOGGER = Logger.getLogger(Nexus3GenericChoiceListProvider.class.getName());
    private String url;
    private String credentialsId;

    @DataBoundConstructor
    public Nexus3GenericChoiceListProvider(String name) {
        super(name);
    }

    @Override
    public IVersionReader createServiceInstance(Item item) {
        Nexus3RestApiAssetGenericService retVal = new Nexus3RestApiAssetGenericService(this.url);
        UsernamePasswordCredentialsImpl c = Nexus3GenericChoiceListProvider.getCredentials(this.getCredentialsId(), item);
        if (c != null) {
            retVal.setCredentials(c.getUsername(), c.getPassword().getPlainText());
        }
        return retVal;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = StringUtils.trim((String)url);
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.setArtifactId(name);
    }

    public String getName() {
        return this.getArtifactId();
    }

    @Extension
    public static class Nexus3GenericDescriptorImpl
    extends Descriptor<ChoiceListProvider> {
        @Inject
        private AbstractMavenArtifactChoiceListProvider.DescriptorImpl delegate;

        public Nexus3GenericDescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Nexus3 Generic Choice Parameter";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item pItem, @QueryParameter String credentialsId) {
            return this.delegate.doFillCredentialsIdItems(pItem, credentialsId);
        }

        @RequirePOST
        public FormValidation doTest(@AncestorInPath Item pItem, @QueryParameter String url, @QueryParameter String credentialsId, @QueryParameter String repositoryId, @QueryParameter String name, @QueryParameter boolean inverseFilter, @QueryParameter String filterExpression, @QueryParameter boolean reverseOrder) {
            pItem.checkPermission(Job.CONFIGURE);
            Nexus3RestApiAssetGenericService service = new Nexus3RestApiAssetGenericService(url);
            UsernamePasswordCredentialsImpl c = AbstractMavenArtifactChoiceListProvider.getCredentials(credentialsId, pItem);
            if (c != null) {
                service.setCredentials(c.getUsername(), c.getPassword().getPlainText());
            }
            if (StringUtils.isEmpty((String)name)) {
                return FormValidation.error((String)"The Name attribute cannot be empty.");
            }
            try {
                Map<String, String> entriesFromURL = this.readURL(service, repositoryId, name, inverseFilter, filterExpression, reverseOrder);
                if (entriesFromURL.isEmpty()) {
                    return FormValidation.ok((String)"(Working, but no Entries found)");
                }
                return FormValidation.ok((String)StringUtils.join(entriesFromURL.values(), (char)'\n'));
            }
            catch (Exception e) {
                return FormValidation.error((String)("error reading versions from url:" + e.getMessage()));
            }
        }

        private Map<String, String> readURL(IVersionReader pInstance, String pRepositoryId, String pName, boolean pInverseFilter, String pFilterExpression, boolean pReverseOrder) {
            Map<String, String> retVal = new LinkedHashMap<String, String>();
            try {
                List<String> choices = pInstance.retrieveVersions(pRepositoryId, "", pName, "", ValidAndInvalidClassifier.getDefault());
                List<String> filteredChoices = AbstractMavenArtifactChoiceListProvider.filterArtifacts(choices, pInverseFilter, pFilterExpression);
                if (pReverseOrder) {
                    Collections.reverse(filteredChoices);
                }
                retVal = MavenArtifactChoiceListProviderUtils.toMap(filteredChoices);
            }
            catch (VersionReaderException e) {
                LOGGER.log(Level.INFO, "failed to retrieve versions from repository for r:" + pRepositoryId + ", n:" + pName, e);
                retVal.put("error", e.getMessage());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "failed to retrieve versions from nexus for r:" + pRepositoryId + ", n:" + pName, e);
                retVal.put("error", "Unexpected Error: " + e.getMessage());
            }
            return retVal;
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"The nexus URL cannot be empty");
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest2 staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }
    }
}

