/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ServletPathSpecTest {
    private void assertBadServletPathSpec(String pathSpec) {
        try {
            new ServletPathSpec(pathSpec);
            Assert.fail((String)("Expected IllegalArgumentException for a bad servlet pathspec on: " + pathSpec));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    private void assertMatches(ServletPathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)true));
    }

    private void assertNotMatches(ServletPathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testBadServletPathSpecA() {
        this.assertBadServletPathSpec("foo");
    }

    @Test
    public void testBadServletPathSpecB() {
        this.assertBadServletPathSpec("/foo/*.do");
    }

    @Test
    public void testBadServletPathSpecC() {
        this.assertBadServletPathSpec("foo/*.do");
    }

    @Test
    public void testBadServletPathSpecD() {
        this.assertBadServletPathSpec("foo/*.*do");
    }

    @Test
    public void testBadServletPathSpecE() {
        this.assertBadServletPathSpec("*do");
    }

    @Test
    public void testDefaultPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pathDepth", (long)-1L, (long)spec.getPathDepth());
    }

    @Test
    public void testExactPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/abs/path");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/abs/path", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pathDepth", (long)2L, (long)spec.getPathDepth());
        this.assertMatches(spec, "/abs/path");
        this.assertNotMatches(spec, "/abs/path/");
        this.assertNotMatches(spec, "/abs/path/more");
        this.assertNotMatches(spec, "/foo");
        this.assertNotMatches(spec, "/foo/abs/path");
        this.assertNotMatches(spec, "/foo/abs/path/");
    }

    @Test
    public void testGetPathInfo() {
        Assert.assertEquals((String)"pathInfo exact", null, (Object)new ServletPathSpec("/Foo/bar").getPathInfo("/Foo/bar"));
        Assert.assertEquals((String)"pathInfo prefix", (Object)"/bar", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/bar"));
        Assert.assertEquals((String)"pathInfo prefix", (Object)"/*", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/*"));
        Assert.assertEquals((String)"pathInfo prefix", (Object)"/", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/"));
        Assert.assertEquals((String)"pathInfo prefix", null, (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo"));
        Assert.assertEquals((String)"pathInfo suffix", null, (Object)new ServletPathSpec("*.ext").getPathInfo("/Foo/bar.ext"));
        Assert.assertEquals((String)"pathInfo default", null, (Object)new ServletPathSpec("/").getPathInfo("/Foo/bar.ext"));
        Assert.assertEquals((String)"pathInfo default", (Object)"/xxx/zzz", (Object)new ServletPathSpec("/*").getPathInfo("/xxx/zzz"));
    }

    @Test
    public void testNullPathSpec() {
        ServletPathSpec spec = new ServletPathSpec(null);
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pathDepth", (long)-1L, (long)spec.getPathDepth());
    }

    @Test
    public void testRootPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pathDepth", (long)-1L, (long)spec.getPathDepth());
    }

    @Test
    public void testPathMatch() {
        Assert.assertEquals((String)"pathMatch exact", (Object)"/Foo/bar", (Object)new ServletPathSpec("/Foo/bar").getPathMatch("/Foo/bar"));
        Assert.assertEquals((String)"pathMatch prefix", (Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo/bar"));
        Assert.assertEquals((String)"pathMatch prefix", (Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo/"));
        Assert.assertEquals((String)"pathMatch prefix", (Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo"));
        Assert.assertEquals((String)"pathMatch suffix", (Object)"/Foo/bar.ext", (Object)new ServletPathSpec("*.ext").getPathMatch("/Foo/bar.ext"));
        Assert.assertEquals((String)"pathMatch default", (Object)"/Foo/bar.ext", (Object)new ServletPathSpec("/").getPathMatch("/Foo/bar.ext"));
        Assert.assertEquals((String)"pathMatch default", (Object)"", (Object)new ServletPathSpec("/*").getPathMatch("/xxx/zzz"));
    }

    @Test
    public void testPrefixPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/downloads/*");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/downloads/*", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pathDepth", (long)2L, (long)spec.getPathDepth());
        this.assertMatches(spec, "/downloads/logo.jpg");
        this.assertMatches(spec, "/downloads/distribution.tar.gz");
        this.assertMatches(spec, "/downloads/distribution.tgz");
        this.assertMatches(spec, "/downloads/distribution.zip");
        this.assertMatches(spec, "/downloads");
        Assert.assertEquals((String)"Spec.pathInfo", (Object)"/", (Object)spec.getPathInfo("/downloads/"));
        Assert.assertEquals((String)"Spec.pathInfo", (Object)"/distribution.zip", (Object)spec.getPathInfo("/downloads/distribution.zip"));
        Assert.assertEquals((String)"Spec.pathInfo", (Object)"/dist/9.0/distribution.tar.gz", (Object)spec.getPathInfo("/downloads/dist/9.0/distribution.tar.gz"));
    }

    @Test
    public void testSuffixPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("*.gz");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"*.gz", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pathDepth", (long)0L, (long)spec.getPathDepth());
        this.assertMatches(spec, "/downloads/distribution.tar.gz");
        this.assertMatches(spec, "/downloads/jetty.log.gz");
        this.assertNotMatches(spec, "/downloads/distribution.zip");
        this.assertNotMatches(spec, "/downloads/distribution.tgz");
        this.assertNotMatches(spec, "/abs/path");
        Assert.assertEquals((String)"Spec.pathInfo", null, (Object)spec.getPathInfo("/downloads/distribution.tar.gz"));
    }
}

