/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.serverlove.compute;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class ServerloveManchesterTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public ServerloveManchesterTemplateBuilderLiveTest() {
        this.provider = "serverlove-z1-man";
    }

    @Test
    public void testTemplateBuilder() {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"10.04");
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"serverlove-z1-man");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"GB-MAN");
    }
}

