/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.jclouds.digitalocean2.ssh.ECDSAKeys;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ECDSAKeysTest")
public class ECDSAKeysTest {
    private static final String expectedFingerPrint = "0e:9f:aa:cc:3e:79:5d:1e:f9:19:58:08:dc:c4:5e:1c";

    @Test
    public void testCanReadRsaAndCompareFingerprintOnPublicECDSAKey() throws IOException {
        String ecdsa = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-ecdsa.pub"));
        String fingerPrint = ECDSAKeys.fingerprintPublicKey((String)ecdsa);
        Assert.assertEquals((String)fingerPrint, (String)expectedFingerPrint);
    }

    @Test
    public void testEncodeAsOpenSSH() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        String ecdsa = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-ecdsa.pub"));
        ECPublicKeySpec spec = ECDSAKeys.publicKeySpecFromOpenSSH((String)ecdsa);
        ECPublicKey key = (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(spec);
        Assert.assertTrue((boolean)ecdsa.startsWith(ECDSAKeys.encodeAsOpenSSH((ECPublicKey)key)));
    }
}

