/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.jclouds.digitalocean2.ssh.DSAKeys;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DSAKeysTest")
public class DSAKeysTest {
    private static final String expectedFingerPrint = "2a:54:bb:8e:ba:44:96:c8:6c:9c:40:34:3c:4d:38:e4";

    @Test
    public void testCanReadRsaAndCompareFingerprintOnPublicRSAKey() throws IOException {
        String dsa = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-dsa.pub"));
        String fingerPrint = DSAKeys.fingerprintPublicKey((String)dsa);
        Assert.assertEquals((String)fingerPrint, (String)expectedFingerPrint);
    }

    @Test
    public void testEncodeAsOpenSSH() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        String dsa = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-dsa.pub"));
        DSAPublicKeySpec spec = DSAKeys.publicKeySpecFromOpenSSH((String)dsa);
        DSAPublicKey key = (DSAPublicKey)KeyFactory.getInstance("DSA").generatePublic(spec);
        Assert.assertEquals((String)DSAKeys.encodeAsOpenSSH((DSAPublicKey)key), (String)dsa);
    }
}

