/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonParser;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.DigitalOcean2ProviderMetadata;
import org.jclouds.json.Json;
import org.jclouds.rest.ApiContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class BaseDigitalOcean2ApiMockTest {
    private static final String MOCK_BEARER_TOKEN = "c5401990f0c24135e8d6b5d260603fc71696d4738da9aa04a720229a01a2521d";
    private static final String DEFAULT_ENDPOINT = new DigitalOcean2ProviderMetadata().getEndpoint();
    private final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.newDirectExecutorService()));
    protected MockWebServer server;
    protected DigitalOcean2Api api;
    private Json json;
    private final JsonParser parser = new JsonParser();

    @BeforeMethod
    public void start() throws IOException {
        this.server = new MockWebServer();
        this.server.play();
        ApiContext ctx = (ApiContext)ContextBuilder.newBuilder((String)"digitalocean2").credentials("", MOCK_BEARER_TOKEN).endpoint(this.url("")).modules(this.modules).overrides(this.overrides()).build();
        this.json = (Json)ctx.utils().injector().getInstance(Json.class);
        this.api = (DigitalOcean2Api)ctx.getApi();
    }

    @AfterMethod(alwaysRun=true)
    public void stop() throws IOException {
        this.server.shutdown();
        this.api.close();
    }

    protected Properties overrides() {
        return new Properties();
    }

    protected String url(String path) {
        return this.server.getUrl(path).toString();
    }

    protected MockResponse jsonResponse(String resource) {
        return new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(this.stringFromResource(resource));
    }

    protected MockResponse response404() {
        return new MockResponse().setStatus("HTTP/1.1 404 Not Found");
    }

    protected MockResponse response204() {
        return new MockResponse().setStatus("HTTP/1.1 204 No Content");
    }

    protected String stringFromResource(String resourceName) {
        try {
            return Resources.toString((URL)this.getClass().getResource(resourceName), (Charset)Charsets.UTF_8).replace(DEFAULT_ENDPOINT, this.url(""));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected <T> T onlyObjectFromResource(String resourceName, TypeToken<Map<String, T>> type) {
        String text = this.stringFromResource(resourceName);
        Map object = (Map)this.json.fromJson(text, type.getType());
        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0, (String)"The given json does not contain any object: %s", (Object[])new Object[]{text});
        Preconditions.checkArgument((object.keySet().size() == 1 ? 1 : 0) != 0, (String)"The given json does not contain more than one object: %s", (Object[])new Object[]{text});
        return (T)object.get(Iterables.getOnlyElement(object.keySet()));
    }

    protected <T> T objectFromResource(String resourceName, Class<T> type) {
        String text = this.stringFromResource(resourceName);
        return (T)this.json.fromJson(text, type);
    }

    protected RecordedRequest assertSent(MockWebServer server, String method, String path) throws InterruptedException {
        RecordedRequest request = server.takeRequest();
        Assert.assertEquals((String)request.getMethod(), (String)method);
        Assert.assertEquals((String)request.getPath(), (String)path);
        Assert.assertEquals((String)request.getHeader("Accept"), (String)"application/json");
        Assert.assertEquals((String)request.getHeader("Authorization"), (String)"Bearer c5401990f0c24135e8d6b5d260603fc71696d4738da9aa04a720229a01a2521d");
        return request;
    }

    protected RecordedRequest assertSent(MockWebServer server, String method, String path, String json) throws InterruptedException {
        RecordedRequest request = this.assertSent(server, method, path);
        Assert.assertEquals((String)request.getHeader("Content-Type"), (String)"application/json");
        Assert.assertEquals((Object)this.parser.parse(new String(request.getBody(), Charsets.UTF_8)), (Object)this.parser.parse(json));
        return request;
    }
}

