/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.config.DigitalOcean2RateLimitModule;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.Size;
import org.testng.Assert;
import org.testng.util.Strings;

public class BaseDigitalOcean2ApiLiveTest
extends BaseApiLiveTest<DigitalOcean2Api> {
    private Predicate<Integer> actionCompleted;
    private Predicate<Integer> nodeTerminated;
    private Predicate<Integer> nodeStopped;
    private Predicate<Integer> nodeRunning;

    public BaseDigitalOcean2ApiLiveTest() {
        this.provider = "digitalocean2";
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.compute.poll-status.initial-period", (Object)1000);
        props.put("jclouds.compute.poll-status.max-period", (Object)10000);
        props.put("jclouds.compute.timeout.image-available", (Object)TimeUnit.MINUTES.toMillis(45L));
        return props;
    }

    protected DigitalOcean2Api create(Properties props, Iterable<Module> modules) {
        Injector injector = this.newBuilder().modules(modules).overrides(props).buildInjector();
        this.actionCompleted = (Predicate)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Predicate<Integer>>(){}));
        this.nodeTerminated = (Predicate)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Predicate<Integer>>(){}, (Annotation)Names.named((String)"jclouds.compute.timeout.node-terminated")));
        this.nodeStopped = (Predicate)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Predicate<Integer>>(){}, (Annotation)Names.named((String)"jclouds.compute.timeout.node-suspended")));
        this.nodeRunning = (Predicate)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Predicate<Integer>>(){}, (Annotation)Names.named((String)"jclouds.compute.timeout.node-running")));
        return (DigitalOcean2Api)injector.getInstance(DigitalOcean2Api.class);
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.builder().addAll(super.setupModules()).add((Object)new DigitalOcean2RateLimitModule()).build();
    }

    protected void assertActionCompleted(int actionId) {
        Assert.assertTrue((boolean)this.actionCompleted.apply((Object)actionId), (String)String.format("Action %s did not complete in the configured timeout", actionId));
    }

    protected void assertNodeStopped(int dropletId) {
        Assert.assertTrue((boolean)this.nodeStopped.apply((Object)dropletId), (String)String.format("Droplet %s did not stop in the configured timeout", dropletId));
    }

    protected void assertNodeRunning(int dropletId) {
        Assert.assertTrue((boolean)this.nodeRunning.apply((Object)dropletId), (String)String.format("Droplet %s did not start in the configured timeout", dropletId));
    }

    protected void assertNodeTerminated(int dropletId) {
        Assert.assertTrue((boolean)this.nodeTerminated.apply((Object)dropletId), (String)String.format("Droplet %s was not terminated in the configured timeout", dropletId));
    }

    protected Region firstAvailableRegion() {
        return (Region)((DigitalOcean2Api)this.api).regionApi().list().concat().firstMatch((Predicate)new Predicate<Region>(){

            public boolean apply(Region input) {
                return input.available();
            }
        }).get();
    }

    protected Size cheapestSizeInRegionForImage(final Region region, final Image image) {
        return (Size)BaseDigitalOcean2ApiLiveTest.sizesByPrice().min((Iterable)((DigitalOcean2Api)this.api).sizeApi().list().concat().filter((Predicate)new Predicate<Size>(){

            public boolean apply(Size input) {
                return input.available() && input.regions().contains(region.slug()) && (float)input.disk() >= image.minDiskSize();
            }
        }));
    }

    protected Image ubuntuImageInRegion(final Region region) {
        return (Image)((DigitalOcean2Api)this.api).imageApi().list().concat().firstMatch((Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return "Ubuntu".equalsIgnoreCase(input.distribution()) && !Strings.isNullOrEmpty((String)input.slug()) && input.regions().contains(region.slug());
            }
        }).get();
    }

    protected static Ordering<Size> sizesByPrice() {
        return new Ordering<Size>(){

            public int compare(Size left, Size right) {
                return ComparisonChain.start().compare(left.priceHourly(), right.priceHourly()).compare(left.priceMonthly(), right.priceMonthly()).result();
            }
        };
    }
}

