/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.functions.LinkToImageListOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="LinkToImageListOptionsTest")
public class LinkToImageListOptionsTest {
    public void testNoOptions() {
        LinkToImageListOptions function = new LinkToImageListOptions();
        ImageListOptions options = function.apply(URI.create("https://api.digitalocean.com/v2/images"));
        Assert.assertNotNull((Object)options);
        Multimap params = options.buildQueryParameters();
        Assert.assertFalse((boolean)params.containsKey((Object)"page"));
        Assert.assertFalse((boolean)params.containsKey((Object)"per_page"));
        Assert.assertFalse((boolean)params.containsKey((Object)"type"));
        Assert.assertFalse((boolean)params.containsKey((Object)"private"));
    }

    public void testWithOptions() {
        LinkToImageListOptions function = new LinkToImageListOptions();
        ImageListOptions options = function.apply(URI.create("https://api.digitalocean.com/v2/images?page=1&per_page=5&type=distribution&private=true"));
        Assert.assertNotNull((Object)options);
        Multimap params = options.buildQueryParameters();
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)params.get((Object)"page"))), (String)"1");
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)params.get((Object)"per_page"))), (String)"5");
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)params.get((Object)"type"))), (String)"distribution");
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)params.get((Object)"private"))), (String)"true");
    }
}

