/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SizeApiMockTest", singleThreaded=true)
public class SizeApiMockTest
extends BaseDigitalOcean2ApiMockTest {
    public void testListSizes() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/sizes-first.json"));
        this.server.enqueue(this.jsonResponse("/sizes-last.json"));
        FluentIterable sizes = this.api.sizeApi().list().concat();
        Assert.assertEquals((int)Iterables.size((Iterable)sizes), (int)9);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/sizes");
        this.assertSent(this.server, "GET", "/sizes?page=2&per_page=5");
    }

    public void testListSizesReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable sizes = this.api.sizeApi().list().concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)sizes));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/sizes");
    }

    public void testListSizesWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/sizes-first.json"));
        IterableWithMarker sizes = this.api.sizeApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertEquals((int)Iterables.size((Iterable)sizes), (int)5);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/sizes?page=1&per_page=5");
    }

    public void testListSizesWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker sizes = this.api.sizeApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)sizes));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/sizes?page=1&per_page=5");
    }
}

