/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Predicate;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Size;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.features.SizeApi;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.util.Strings;

@Test(groups={"live"}, testName="SizeApiLiveTest")
public class SizeApiLiveTest
extends BaseDigitalOcean2ApiLiveTest {
    public void testListSizes() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list().concat().limit(50).allMatch((Predicate)new Predicate<Size>(){

            public boolean apply(Size input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.slug());
            }
        }), (String)"All sizes must have the 'slug' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some sizes to be returned");
    }

    public void testListSizesOnePage() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list(ListOptions.Builder.page((int)1)).allMatch((Predicate)new Predicate<Size>(){

            public boolean apply(Size input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.slug());
            }
        }), (String)"All sizes must have the 'slug' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some sizes to be returned");
    }

    private SizeApi api() {
        return ((DigitalOcean2Api)this.api).sizeApi();
    }
}

