/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionApiMockTest", singleThreaded=true)
public class RegionApiMockTest
extends BaseDigitalOcean2ApiMockTest {
    public void testListRegions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/regions-first.json"));
        this.server.enqueue(this.jsonResponse("/regions-last.json"));
        FluentIterable regions = this.api.regionApi().list().concat();
        Assert.assertEquals((int)Iterables.size((Iterable)regions), (int)10);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/regions");
        this.assertSent(this.server, "GET", "/regions?page=2&per_page=5");
    }

    public void testListRegionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable regions = this.api.regionApi().list().concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)regions));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/regions");
    }

    public void testListRegionsWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/regions-first.json"));
        IterableWithMarker regions = this.api.regionApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertEquals((int)Iterables.size((Iterable)regions), (int)5);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/regions?page=1&per_page=5");
    }

    public void testListRegionsWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker regions = this.api.regionApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)regions));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/regions?page=1&per_page=5");
    }
}

