/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Predicate;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.features.RegionApi;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.util.Strings;

@Test(groups={"live"}, testName="RegionApiLiveTest")
public class RegionApiLiveTest
extends BaseDigitalOcean2ApiLiveTest {
    public void testListRegions() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list().concat().limit(50).allMatch((Predicate)new Predicate<Region>(){

            public boolean apply(Region input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.slug());
            }
        }), (String)"All regions must have the 'slug' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some regions to be returned");
    }

    public void testListRegionsOnePage() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list(ListOptions.Builder.page((int)1)).allMatch((Predicate)new Predicate<Region>(){

            public boolean apply(Region input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.slug());
            }
        }), (String)"All regions must have the 'slug' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some regions to be returned");
    }

    private RegionApi api() {
        return ((DigitalOcean2Api)this.api).regionApi();
    }
}

