/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.domain.Key;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="KeyApiMockTest", singleThreaded=true)
public class KeyApiMockTest
extends BaseDigitalOcean2ApiMockTest {
    public void testListKeys() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/keys-first.json"));
        this.server.enqueue(this.jsonResponse("/keys-last.json"));
        FluentIterable keys = this.api.keyApi().list().concat();
        Assert.assertEquals((int)Iterables.size((Iterable)keys), (int)7);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/account/keys");
        this.assertSent(this.server, "GET", "/account/keys?page=2&per_page=5");
    }

    public void testListKeysReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable keys = this.api.keyApi().list().concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)keys));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/account/keys");
    }

    public void testListKeysWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/keys-first.json"));
        IterableWithMarker keys = this.api.keyApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertEquals((int)Iterables.size((Iterable)keys), (int)5);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/account/keys?page=1&per_page=5");
    }

    public void testListKeysWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker keys = this.api.keyApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)keys));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/account/keys?page=1&per_page=5");
    }

    public void testCreateKey() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/key.json").setStatus("HTTP/1.1 201 Created"));
        String dsa = this.stringFromResource("/ssh-dsa.pub");
        Key key = this.api.keyApi().create("foo", dsa);
        Assert.assertEquals((Object)key, (Object)this.keyFromResource("/key.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/account/keys", String.format("{\"name\":\"foo\", \"public_key\":\"%s\"}", dsa));
    }

    public void testGetKey() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/key.json"));
        Key key = this.api.keyApi().get(1);
        Assert.assertEquals((Object)key, (Object)this.keyFromResource("/key.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/account/keys/1");
    }

    public void testGetKeyReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        Key key = this.api.keyApi().get(1);
        Assert.assertNull((Object)key);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/account/keys/1");
    }

    public void testGetKeyUsingFingerprint() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/key.json"));
        Key key = this.api.keyApi().get("1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
        Assert.assertEquals((Object)key, (Object)this.keyFromResource("/key.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/account/keys/1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
    }

    public void testGetKeyUsingFingerprintReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        Key key = this.api.keyApi().get("1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
        Assert.assertNull((Object)key);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/account/keys/1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
    }

    public void testUpdateKey() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/key.json"));
        Key key = this.api.keyApi().update(1, "foo");
        Assert.assertEquals((Object)key, (Object)this.keyFromResource("/key.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "PUT", "/account/keys/1", "{\"name\":\"foo\"}");
    }

    public void testUpdateKeyUsingFingerprint() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/key.json"));
        Key key = this.api.keyApi().update("1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90", "foo");
        Assert.assertEquals((Object)key, (Object)this.keyFromResource("/key.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "PUT", "/account/keys/1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90", "{\"name\":\"foo\"}");
    }

    public void testDeleteKey() throws InterruptedException {
        this.server.enqueue(this.response204());
        this.api.keyApi().delete(1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/account/keys/1");
    }

    public void testDeleteKeyReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        this.api.keyApi().delete(1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/account/keys/1");
    }

    public void testDeleteKeyUsingFingerprint() throws InterruptedException {
        this.server.enqueue(this.response204());
        this.api.keyApi().delete("1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/account/keys/1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
    }

    public void testDeleteKeyUsingfingerprintReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        this.api.keyApi().delete("1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/account/keys/1a:cc:9b:88:c8:4f:b8:77:96:15:d2:0c:95:86:ff:90");
    }

    private Key keyFromResource(String resource) {
        return this.onlyObjectFromResource(resource, new TypeToken<Map<String, Key>>(){
            private static final long serialVersionUID = 1L;
        });
    }
}

