/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Key;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.features.KeyApi;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="KeyApiLiveTest")
public class KeyApiLiveTest
extends BaseDigitalOcean2ApiLiveTest {
    private Key dsa;
    private Key ecdsa;

    public void testCreateKey() {
        this.dsa = this.api().create("jclouds-test-dsa", this.loadKey("/ssh-dsa.pub"));
        this.ecdsa = this.api().create("jclouds-test-ecdsa", this.loadKey("/ssh-ecdsa.pub"));
        Assert.assertEquals((String)this.dsa.name(), (String)"jclouds-test-dsa");
        Assert.assertEquals((String)this.ecdsa.name(), (String)"jclouds-test-ecdsa");
    }

    @Test(dependsOnMethods={"testCreateKey"})
    public void testListKeys() {
        FluentIterable keys = this.api().list().concat();
        Assert.assertTrue((keys.size() >= 2 ? 1 : 0) != 0, (String)"At least the two created keys must exist");
    }

    @Test(dependsOnMethods={"testCreateKey"})
    public void testListKeysOnePAge() {
        IterableWithMarker keys = this.api().list(ListOptions.Builder.page((int)1));
        Assert.assertTrue((keys.size() >= 2 ? 1 : 0) != 0, (String)"At least the two created keys must exist");
    }

    @Test(dependsOnMethods={"testCreateKey"})
    public void testGetKey() {
        Assert.assertEquals((String)this.api().get(this.dsa.id()).fingerprint(), (String)this.dsa.fingerprint());
        Assert.assertEquals((int)this.api().get(this.ecdsa.fingerprint()).id(), (int)this.ecdsa.id());
    }

    @Test(dependsOnMethods={"testCreateKey"})
    public void testUpdateKey() {
        this.api().update(this.dsa.id(), "jclouds-test-dsa-updated");
        Assert.assertEquals((String)this.api().get(this.dsa.id()).name(), (String)"jclouds-test-dsa-updated");
    }

    @AfterClass(alwaysRun=true)
    public void testDeleteKey() {
        FluentIterable keys;
        if (this.dsa != null) {
            this.api().delete(this.dsa.id());
            keys = this.api().list().concat();
            Assert.assertFalse((boolean)keys.contains((Object)this.dsa), (String)"dsa key must not be present in list");
        }
        if (this.ecdsa != null) {
            this.api().delete(this.ecdsa.fingerprint());
            keys = this.api().list().concat();
            Assert.assertFalse((boolean)keys.contains((Object)this.ecdsa), (String)"dsa key must not be present in list");
        }
    }

    private String loadKey(String resourceName) {
        try {
            return Resources.toString((URL)((Object)((Object)this)).getClass().getResource(resourceName), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private KeyApi api() {
        return ((DigitalOcean2Api)this.api).keyApi();
    }
}

