/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ImageApiMockTest", singleThreaded=true)
public class ImageApiMockTest
extends BaseDigitalOcean2ApiMockTest {
    public void testListImages() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/images-first.json"));
        this.server.enqueue(this.jsonResponse("/images-last.json"));
        FluentIterable images = this.api.imageApi().list().concat();
        Assert.assertEquals((int)Iterables.size((Iterable)images), (int)10);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/images");
        this.assertSent(this.server, "GET", "/images?page=2&per_page=5&type=distribution");
    }

    public void testListImagesReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable images = this.api.imageApi().list().concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)images));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/images");
    }

    public void testListImagesWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/images-first.json"));
        IterableWithMarker images = this.api.imageApi().list(ImageListOptions.Builder.page((int)1).perPage(5).type("distribution"));
        Assert.assertEquals((int)Iterables.size((Iterable)images), (int)5);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/images?page=1&per_page=5&type=distribution");
    }

    public void testListImagesWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker images = this.api.imageApi().list(ImageListOptions.Builder.page((int)1).perPage(5).type("distribution"));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)images));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/images?page=1&per_page=5&type=distribution");
    }

    public void testGetImage() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/image.json"));
        Image image = this.api.imageApi().get(1);
        Assert.assertEquals((Object)image, (Object)this.imageFromResource("/image.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/images/1");
    }

    public void testGetImageReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        Image image = this.api.imageApi().get(1);
        Assert.assertNull((Object)image);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/images/1");
    }

    public void testGetImageUsingSlug() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/image.json"));
        Image image = this.api.imageApi().get("foo");
        Assert.assertEquals((Object)image, (Object)this.imageFromResource("/image.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/images/foo");
    }

    public void testGetImageUsingSlugReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        Image image = this.api.imageApi().get("foo");
        Assert.assertNull((Object)image);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/images/foo");
    }

    public void testDeleteImage() throws InterruptedException {
        this.server.enqueue(this.response204());
        this.api.imageApi().delete(1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/images/1");
    }

    public void testDeleteImageReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        this.api.imageApi().delete(1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/images/1");
    }

    private Image imageFromResource(String resource) {
        return this.onlyObjectFromResource(resource, new TypeToken<Map<String, Image>>(){
            private static final long serialVersionUID = 1L;
        });
    }
}

