/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.features.ImageApi;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.util.Strings;

@Test(groups={"live"}, testName="ImageApiLiveTest")
public class ImageApiLiveTest
extends BaseDigitalOcean2ApiLiveTest {
    public void testListImages() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list().concat().limit(50).allMatch((Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.name());
            }
        }), (String)"All images must have the 'name' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some images to be returned");
    }

    public void testListImagesOnePage() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list(ImageListOptions.Builder.page((int)1).perPage(5)).allMatch((Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.name());
            }
        }), (String)"All images must have the 'name' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some images to be returned");
    }

    public void testListImagesByType() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list(ImageListOptions.Builder.type((String)"distribution").perPage(5)).allMatch((Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.distribution());
            }
        }), (String)"All images must have the 'distribution' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some images to be returned");
    }

    public void testGetImage() {
        Optional first = this.api().list().concat().first();
        Assert.assertTrue((boolean)first.isPresent(), (String)"At least one image was expected to exist");
        Assert.assertNotNull((Object)this.api().get(((Image)first.get()).id()));
    }

    public void testGetImageBySlug() {
        Optional first = this.api().list().concat().firstMatch((Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return !Strings.isNullOrEmpty((String)input.slug());
            }
        });
        Assert.assertTrue((boolean)first.isPresent(), (String)"At least one image with the 'slug' field set was expected to exist");
        Assert.assertNotNull((Object)this.api().get(((Image)first.get()).slug()));
    }

    private ImageApi api() {
        return ((DigitalOcean2Api)this.api).imageApi();
    }
}

