/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.DropletCreate;
import org.jclouds.digitalocean2.domain.options.CreateDropletOptions;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DropletApiMockTest", singleThreaded=true)
public class DropletApiMockTest
extends BaseDigitalOcean2ApiMockTest {
    public void testListDroplets() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/droplets-first.json"));
        this.server.enqueue(this.jsonResponse("/droplets-last.json"));
        FluentIterable droplets = this.api.dropletApi().list().concat();
        Assert.assertEquals((int)Iterables.size((Iterable)droplets), (int)2);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/droplets");
        this.assertSent(this.server, "GET", "/droplets?page=2&per_page=1");
    }

    public void testListDropletsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable droplets = this.api.dropletApi().list().concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)droplets));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets");
    }

    public void testListDropletsWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/droplets-first.json"));
        IterableWithMarker droplets = this.api.dropletApi().list(ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertEquals((int)Iterables.size((Iterable)droplets), (int)1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets?page=1&per_page=20");
    }

    public void testListDropletsWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker droplets = this.api.dropletApi().list(ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)droplets));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets?page=1&per_page=20");
    }

    public void testGetDroplet() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/droplet.json"));
        Droplet droplet = this.api.dropletApi().get(1);
        Assert.assertEquals((Object)droplet, (Object)this.dropletFromResource("/droplet.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/1");
    }

    public void testGetDropletReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        Droplet droplet = this.api.dropletApi().get(1);
        Assert.assertNull((Object)droplet);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/1");
    }

    public void testCreateDroplet() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/droplet-create-res.json"));
        DropletCreate droplet = this.api.dropletApi().create("digitalocean2-s-d5e", "sfo1", "512mb", "6374124", CreateDropletOptions.builder().addSshKeyId(421192).build());
        Assert.assertEquals((Object)droplet, (Object)this.objectFromResource("/droplet-create-res.json", DropletCreate.class));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/droplets", this.stringFromResource("/droplet-create-req.json"));
    }

    public void testListKernels() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/kernels-first.json"));
        this.server.enqueue(this.jsonResponse("/kernels-last.json"));
        FluentIterable kernels = this.api.dropletApi().listKernels(5425561).concat();
        Assert.assertEquals((int)Iterables.size((Iterable)kernels), (int)10);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/droplets/5425561/kernels");
        this.assertSent(this.server, "GET", "/droplets/5425561/kernels?page=2");
    }

    public void testListKernelsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable kernels = this.api.dropletApi().listKernels(5425561).concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)kernels));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/kernels");
    }

    public void testListKernelsWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/kernels-first.json"));
        IterableWithMarker kernels = this.api.dropletApi().listKernels(5425561, ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertEquals((int)Iterables.size((Iterable)kernels), (int)5);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/kernels?page=1&per_page=20");
    }

    public void testListKernelsWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker kernels = this.api.dropletApi().listKernels(5425561, ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)kernels));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/kernels?page=1&per_page=20");
    }

    public void testListActions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/actions-first.json"));
        this.server.enqueue(this.jsonResponse("/actions-last.json"));
        FluentIterable actions = this.api.dropletApi().listActions(1).concat();
        Assert.assertEquals((int)Iterables.size((Iterable)actions), (int)8);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/droplets/1/actions");
        this.assertSent(this.server, "GET", "/droplets/1/actions?page=2&per_page=5");
    }

    public void testListActionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable actions = this.api.dropletApi().listActions(1).concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)actions));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/1/actions");
    }

    public void testListActionsWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/actions-first.json"));
        IterableWithMarker actions = this.api.dropletApi().listActions(1, ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertEquals((int)Iterables.size((Iterable)actions), (int)5);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/1/actions?page=1&per_page=5");
    }

    public void testListActionsWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker actions = this.api.dropletApi().listActions(1, ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)actions));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/1/actions?page=1&per_page=5");
    }

    public void testListBackups() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/backups-first.json"));
        this.server.enqueue(this.jsonResponse("/backups-last.json"));
        FluentIterable backups = this.api.dropletApi().listBackups(5425561).concat();
        Assert.assertEquals((int)Iterables.size((Iterable)backups), (int)2);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/droplets/5425561/backups");
        this.assertSent(this.server, "GET", "/droplets/5425561/backups?page=2");
    }

    public void testListBackupsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable backups = this.api.dropletApi().listBackups(5425561).concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)backups));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/backups");
    }

    public void testListBackupsWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/backups-first.json"));
        IterableWithMarker backups = this.api.dropletApi().listBackups(5425561, ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertEquals((int)Iterables.size((Iterable)backups), (int)1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/backups?page=1&per_page=20");
    }

    public void testListBackupsWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker backups = this.api.dropletApi().listBackups(5425561, ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)backups));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/backups?page=1&per_page=20");
    }

    public void testListSnapshots() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/snapshots-first.json"));
        this.server.enqueue(this.jsonResponse("/snapshots-last.json"));
        FluentIterable snapshots = this.api.dropletApi().listSnapshots(5425561).concat();
        Assert.assertEquals((int)Iterables.size((Iterable)snapshots), (int)2);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/droplets/5425561/snapshots");
        this.assertSent(this.server, "GET", "/droplets/5425561/snapshots?page=2");
    }

    public void testListSnapshotsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable snapshots = this.api.dropletApi().listSnapshots(5425561).concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)snapshots));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/snapshots");
    }

    public void testListSnapshotsWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/snapshots-first.json"));
        IterableWithMarker snapshots = this.api.dropletApi().listSnapshots(5425561, ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertEquals((int)Iterables.size((Iterable)snapshots), (int)1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/snapshots?page=1&per_page=20");
    }

    public void testListSnapshotsWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker snapshots = this.api.dropletApi().listSnapshots(5425561, ListOptions.Builder.page((int)1).perPage(20));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)snapshots));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/droplets/5425561/snapshots?page=1&per_page=20");
    }

    public void testDeleteDroplet() throws InterruptedException {
        this.server.enqueue(this.response204());
        this.api.dropletApi().delete(1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/droplets/1");
    }

    public void testDeleteDropletReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        this.api.dropletApi().delete(1);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "DELETE", "/droplets/1");
    }

    public void testPowerCycleDroplet() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/power-cycle.json"));
        Action action = this.api.dropletApi().powerCycle(1);
        Assert.assertEquals((Object)action, (Object)this.actionFromResource("/power-cycle.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/droplets/1/actions", "{\"type\":\"power_cycle\"}");
    }

    public void testPowerOn() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/power-on.json"));
        Action action = this.api.dropletApi().powerOn(1);
        Assert.assertEquals((Object)action, (Object)this.actionFromResource("/power-on.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/droplets/1/actions", "{\"type\":\"power_on\"}");
    }

    public void testPowerOff() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/power-off.json"));
        Action action = this.api.dropletApi().powerOff(1);
        Assert.assertEquals((Object)action, (Object)this.actionFromResource("/power-off.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/droplets/1/actions", "{\"type\":\"power_off\"}");
    }

    public void testReboot() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/reboot.json"));
        Action action = this.api.dropletApi().reboot(1);
        Assert.assertEquals((Object)action, (Object)this.actionFromResource("/reboot.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/droplets/1/actions", "{\"type\":\"reboot\"}");
    }

    public void testShutdown() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/shutdown.json"));
        Action action = this.api.dropletApi().shutdown(1);
        Assert.assertEquals((Object)action, (Object)this.actionFromResource("/shutdown.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/droplets/1/actions", "{\"type\":\"shutdown\"}");
    }

    public void testSnapshot() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/snapshot.json"));
        Action action = this.api.dropletApi().snapshot(1, "foo");
        Assert.assertEquals((Object)action, (Object)this.actionFromResource("/snapshot.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "POST", "/droplets/1/actions", "{\"type\":\"snapshot\",\"name\":\"foo\"}");
    }

    private Droplet dropletFromResource(String resource) {
        return this.onlyObjectFromResource(resource, new TypeToken<Map<String, Droplet>>(){
            private static final long serialVersionUID = 1L;
        });
    }

    private Action actionFromResource(String resource) {
        return this.onlyObjectFromResource(resource, new TypeToken<Map<String, Action>>(){
            private static final long serialVersionUID = 1L;
        });
    }
}

