/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.logging.Logger;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.DropletCreate;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Key;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.Size;
import org.jclouds.digitalocean2.domain.Snapshot;
import org.jclouds.digitalocean2.domain.options.CreateDropletOptions;
import org.jclouds.digitalocean2.features.DropletApi;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiLiveTest;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="DropletApiLiveTest")
public class DropletApiLiveTest
extends BaseDigitalOcean2ApiLiveTest {
    private Region region;
    private Size size;
    private Image image;
    private Key key;
    private int dropletId = -1;

    @BeforeClass
    public void setupDroplet() {
        this.region = this.firstAvailableRegion();
        this.image = this.ubuntuImageInRegion(this.region);
        this.size = this.cheapestSizeInRegionForImage(this.region, this.image);
        Map keyPair = SshKeys.generate();
        this.key = ((DigitalOcean2Api)this.api).keyApi().create(this.prefix + "-droplet-livetest", (String)keyPair.get("public"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.key != null) {
            ((DigitalOcean2Api)this.api).keyApi().delete(this.key.id());
        }
    }

    public void testCreate() {
        DropletCreate dropletCreate = this.api().create(this.prefix + "-droplet-livetest", this.region.slug(), this.size.slug(), this.image.slug(), CreateDropletOptions.builder().backupsEnabled(true).addSshKeyId(this.key.id()).build());
        this.dropletId = dropletCreate.droplet().id();
        this.assertNodeRunning(this.dropletId);
        Droplet droplet = this.api().get(this.dropletId);
        Assert.assertNotNull((Object)droplet, (String)"Droplet should not be null");
    }

    @Test(groups={"live"}, dependsOnMethods={"testCreate"})
    public void testListDroplets() {
        Assert.assertTrue((boolean)this.api().list().concat().anyMatch((Predicate)new Predicate<Droplet>(){

            public boolean apply(Droplet input) {
                return input.id() == DropletApiLiveTest.this.dropletId;
            }
        }), (String)"The created droplet must be in the list");
    }

    @Test(dependsOnMethods={"testCreate"})
    public void testListKernels() {
        FluentIterable kernels = this.api().listKernels(this.dropletId).concat();
        Assert.assertTrue((boolean)kernels.iterator().hasNext());
    }

    @Test(dependsOnMethods={"testListKernels"})
    public void testPowerOff() {
        this.api().powerOff(this.dropletId);
        this.assertNodeStopped(this.dropletId);
    }

    @Test(groups={"live"}, dependsOnMethods={"testPowerOff"})
    public void testPowerOn() {
        this.api().powerOn(this.dropletId);
        this.assertNodeRunning(this.dropletId);
    }

    @Test(groups={"live"}, dependsOnMethods={"testPowerOn"})
    public void testSnapshots() {
        Action action = this.api().snapshot(this.dropletId, this.prefix + this.dropletId + "-snapshot");
        this.assertActionCompleted(action.id());
        ImmutableList snapshots = this.api().listSnapshots(this.dropletId).concat().toList();
        Assert.assertEquals((int)snapshots.size(), (int)1, (String)"Must contain 1 snapshot");
        for (Snapshot snapshot : snapshots) {
            try {
                ((DigitalOcean2Api)this.api).imageApi().delete(snapshot.id());
            }
            catch (Exception ex) {
                Logger.getAnonymousLogger().warning("Could not delete snapshot: " + snapshot.id());
            }
        }
    }

    @Test(groups={"live"}, dependsOnMethods={"testSnapshots"})
    public void testBackups() {
        FluentIterable backups = this.api().listBackups(this.dropletId).concat();
        Assert.assertNotNull((Object)backups);
    }

    @Test(groups={"live"}, dependsOnMethods={"testSnapshots"})
    public void testListActions() {
        FluentIterable actions = this.api().listActions(this.dropletId).concat();
        Assert.assertTrue((boolean)actions.anyMatch((Predicate)new Predicate<Action>(){

            public boolean apply(Action input) {
                return "snapshot".equals(input.type());
            }
        }));
    }

    @Test(groups={"live"}, dependsOnMethods={"testSnapshots"})
    public void testReboot() {
        Action action = this.api().reboot(this.dropletId);
        this.assertActionCompleted(action.id());
        this.assertNodeRunning(this.dropletId);
    }

    @Test(groups={"live"}, dependsOnMethods={"testReboot"})
    public void testPowerCycle() {
        Action action = this.api().powerCycle(this.dropletId);
        this.assertActionCompleted(action.id());
        this.assertNodeRunning(this.dropletId);
    }

    @Test(groups={"live"}, dependsOnMethods={"testPowerCycle"})
    public void testShutdown() {
        Action action = this.api().shutdown(this.dropletId);
        this.assertActionCompleted(action.id());
    }

    @Test(groups={"live"}, dependsOnMethods={"testShutdown"}, alwaysRun=true)
    public void testDelete() throws InterruptedException {
        if (this.dropletId != -1) {
            this.api().delete(this.dropletId);
            this.assertNodeTerminated(this.dropletId);
            Assert.assertNull((Object)this.api().get(this.dropletId));
        }
    }

    private DropletApi api() {
        return ((DigitalOcean2Api)this.api).dropletApi();
    }
}

