/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ActionApiMockTest", singleThreaded=true)
public class ActionApiMockTest
extends BaseDigitalOcean2ApiMockTest {
    public void testListActions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/actions-first.json"));
        this.server.enqueue(this.jsonResponse("/actions-last.json"));
        FluentIterable actions = this.api.actionApi().list().concat();
        Assert.assertEquals((int)Iterables.size((Iterable)actions), (int)8);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)2);
        this.assertSent(this.server, "GET", "/actions");
        this.assertSent(this.server, "GET", "/actions?page=2&per_page=5");
    }

    public void testListActionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        FluentIterable actions = this.api.actionApi().list().concat();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)actions));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/actions");
    }

    public void testListActionsWithOptions() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/actions-first.json"));
        IterableWithMarker actions = this.api.actionApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertEquals((int)Iterables.size((Iterable)actions), (int)5);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/actions?page=1&per_page=5");
    }

    public void testListActionsWithOptionsReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        IterableWithMarker actions = this.api.actionApi().list(ListOptions.Builder.page((int)1).perPage(5));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)actions));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/actions?page=1&per_page=5");
    }

    public void testGetAction() throws InterruptedException {
        this.server.enqueue(this.jsonResponse("/action.json"));
        Action action = this.api.actionApi().get(1);
        Assert.assertEquals((Object)action, (Object)this.actionFromResource("/action.json"));
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/actions/1");
    }

    public void testGetActionReturns404() throws InterruptedException {
        this.server.enqueue(this.response404());
        Action action = this.api.actionApi().get(1);
        Assert.assertNull((Object)action);
        Assert.assertEquals((int)this.server.getRequestCount(), (int)1);
        this.assertSent(this.server, "GET", "/actions/1");
    }

    private Action actionFromResource(String resource) {
        return this.onlyObjectFromResource(resource, new TypeToken<Map<String, Action>>(){
            private static final long serialVersionUID = 1L;
        });
    }
}

