/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.features.ActionApi;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.util.Strings;

@Test(groups={"live"}, testName="ActionApiLiveTest")
public class ActionApiLiveTest
extends BaseDigitalOcean2ApiLiveTest {
    public void testListActions() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list().concat().limit(50).allMatch((Predicate)new Predicate<Action>(){

            public boolean apply(Action input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.type());
            }
        }), (String)"All actions must have the 'type' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some actions to be returned");
    }

    public void testListActionsOnePage() {
        final AtomicInteger found = new AtomicInteger(0);
        Assert.assertTrue((boolean)this.api().list((ListOptions)ImageListOptions.Builder.page((int)1).perPage(5)).allMatch((Predicate)new Predicate<Action>(){

            public boolean apply(Action input) {
                found.incrementAndGet();
                return !Strings.isNullOrEmpty((String)input.type());
            }
        }), (String)"All actions must have the 'type' field populated");
        Assert.assertTrue((found.get() > 0 ? 1 : 0) != 0, (String)"Expected some actions to be returned");
    }

    public void testGetAction() {
        Optional first = this.api().list().concat().first();
        Assert.assertTrue((boolean)first.isPresent(), (String)"At least one action was expected to exist");
        Assert.assertNotNull((Object)this.api().get(((Action)first.get()).id()));
    }

    private ActionApi api() {
        return ((DigitalOcean2Api)this.api).actionApi();
    }
}

