/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.exceptions;

import com.squareup.okhttp.mockwebserver.MockResponse;
import java.util.Properties;
import org.jclouds.digitalocean2.exceptions.DigitalOcean2RateLimitExceededException;
import org.jclouds.digitalocean2.handlers.DigitalOcean2RateLimitRetryHandler;
import org.jclouds.digitalocean2.internal.BaseDigitalOcean2ApiMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RateLimitExceptionMockTest", singleThreaded=true)
public class RateLimitExceptionMockTest
extends BaseDigitalOcean2ApiMockTest {
    @Override
    protected Properties overrides() {
        Properties overrides = super.overrides();
        overrides.put("jclouds.max-retries", "0");
        return overrides;
    }

    public void testRateLimitExceptionIsThrown() throws InterruptedException {
        long reset = System.currentTimeMillis() / 1000L + 3600L;
        long millisToReset = DigitalOcean2RateLimitRetryHandler.millisUntilNextAvailableRequest((long)reset);
        this.server.enqueue(new MockResponse().setResponseCode(429).addHeader("RateLimit-Limit", (Object)"5000").addHeader("RateLimit-Remaining", (Object)"1235").addHeader("RateLimit-Reset", (Object)String.valueOf(reset)));
        try {
            this.api.keyApi().list();
            Assert.fail((String)"Expected a DigitalOcean2RateLimitExceededException to be thrown");
        }
        catch (DigitalOcean2RateLimitExceededException ex) {
            Assert.assertEquals((int)ex.totalRequestsPerHour(), (int)5000);
            Assert.assertEquals((int)ex.remainingRequests(), (int)1235);
            Assert.assertTrue((ex.timeToNextAvailableRequest() < millisToReset && ex.timeToNextAvailableRequest() > millisToReset - 1800000L ? 1 : 0) != 0);
        }
    }
}

