/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import org.jclouds.digitalocean2.domain.Distribution;
import org.jclouds.digitalocean2.domain.OperatingSystem;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OperatingSystemTest")
public class OperatingSystemTest {
    public void testParseStandard64bit() {
        OperatingSystem os = OperatingSystem.create((String)"12.10 x64", (String)"Ubuntu");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.version(), (String)"12.10");
        Assert.assertEquals((String)os.arch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testLongVersionStandard64bit() {
        OperatingSystem os = OperatingSystem.create((String)"12.10.1 x64", (String)"Ubuntu");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.version(), (String)"12.10.1");
        Assert.assertEquals((String)os.arch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testParseStandard64bitWithPrefix() {
        OperatingSystem os = OperatingSystem.create((String)"Arch Linux 12.10 x64 Desktop", (String)"Arch Linux");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.ARCHLINUX);
        Assert.assertEquals((String)os.version(), (String)"12.10");
        Assert.assertEquals((String)os.arch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testParseStandard() {
        OperatingSystem os = OperatingSystem.create((String)"12.10 x32", (String)"Ubuntu");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.version(), (String)"12.10");
        Assert.assertEquals((String)os.arch(), (String)"x32");
        Assert.assertFalse((boolean)os.is64bit());
        os = OperatingSystem.create((String)"6.5 x64", (String)"CentOS");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.CENTOS);
        Assert.assertEquals((String)os.version(), (String)"6.5");
        Assert.assertEquals((String)os.arch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
        os = OperatingSystem.create((String)"6.5 x64", (String)"Centos");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.CENTOS);
        Assert.assertEquals((String)os.version(), (String)"6.5");
        Assert.assertEquals((String)os.arch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testParseNoArch() {
        OperatingSystem os = OperatingSystem.create((String)"12.10", (String)"Ubuntu");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.version(), (String)"12.10");
        Assert.assertEquals((String)os.arch(), (String)"");
        Assert.assertFalse((boolean)os.is64bit());
    }

    public void testParseNoVersion() {
        OperatingSystem os = OperatingSystem.create((String)"x64", (String)"Ubuntu");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.version(), (String)"");
        Assert.assertEquals((String)os.arch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testParseUnknownDistribution() {
        OperatingSystem os = OperatingSystem.create((String)"12.04 x64", (String)"Foo");
        Assert.assertEquals((Object)os.distribution(), (Object)Distribution.UNRECOGNIZED);
        Assert.assertEquals((String)os.version(), (String)"12.04");
        Assert.assertEquals((String)os.arch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }
}

