/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.options;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.digitalocean2.compute.options.DigitalOcean2TemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DigitalOcean2TemplateOptionsTest")
public class DigitalOcean2TemplateOptionsTest {
    @Test
    public void testSShKeyIds() {
        DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions().sshKeyIds((Iterable)ImmutableSet.of((Object)1, (Object)2, (Object)3));
        Assert.assertEquals((Set)((DigitalOcean2TemplateOptions)options.as(DigitalOcean2TemplateOptions.class)).getSshKeyIds(), (Set)ImmutableSet.of((Object)1, (Object)2, (Object)3));
    }

    @Test
    public void testPrivateNetworking() {
        DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions().privateNetworking(true);
        Assert.assertEquals((boolean)((DigitalOcean2TemplateOptions)options.as(DigitalOcean2TemplateOptions.class)).getPrivateNetworking(), (boolean)true);
    }

    @Test
    public void testBackupsEnabled() {
        DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions().backupsEnabled(true);
        Assert.assertEquals((boolean)((DigitalOcean2TemplateOptions)options.as(DigitalOcean2TemplateOptions.class)).getBackupsEnabled(), (boolean)true);
    }

    @Test
    public void testAutoCreateKeyPair() {
        DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions().autoCreateKeyPair(false);
        Assert.assertEquals((boolean)((DigitalOcean2TemplateOptions)options.as(DigitalOcean2TemplateOptions.class)).getAutoCreateKeyPair(), (boolean)false);
    }

    @Test
    public void testUserData() {
        byte[] userData = "Lorem ipsum".getBytes();
        DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions().userData(userData);
        Assert.assertEquals((byte[])((DigitalOcean2TemplateOptions)options.as(DigitalOcean2TemplateOptions.class)).getUserData(), (byte[])userData);
    }
}

