/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.digitalocean2.compute.functions.SizeToHardware;
import org.jclouds.digitalocean2.domain.Size;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SizeToHardwareTest")
public class SizeToHardwareTest {
    @Test
    public void testConvertSize() {
        Size size = Size.create((String)"2gb", (boolean)true, (float)1.0f, (float)10.0f, (float)0.05f, (int)2048, (int)1, (int)20, (List)ImmutableList.of());
        Hardware expected = new HardwareBuilder().id("2gb").providerId("2gb").name("2gb").processor(new Processor(1.0, 1.0)).ram(2048).volume(new VolumeBuilder().size(Float.valueOf(20.0f)).type(Volume.Type.LOCAL).build()).userMetadata((Map)ImmutableMap.of((Object)"costPerHour", (Object)"0.05", (Object)"costPerMonth", (Object)"10")).build();
        SizeToHardware function = new SizeToHardware();
        Assert.assertEquals((Object)function.apply(size), (Object)expected);
    }
}

