/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jclouds.digitalocean2.DigitalOcean2ProviderMetadata;
import org.jclouds.digitalocean2.compute.functions.RegionToLocation;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionToLocationTest")
public class RegionToLocationTest {
    @Test
    public void testConvertRegion() {
        DigitalOcean2ProviderMetadata metadata = new DigitalOcean2ProviderMetadata();
        JustProvider locationsSupplier = new JustProvider(metadata.getId(), Suppliers.ofInstance((Object)URI.create(metadata.getEndpoint())), (Set)ImmutableSet.of());
        Region region = Region.create((String)"reg1", (String)"Region1", (List)ImmutableList.of(), (boolean)true, (List)ImmutableList.of((Object)"virtio", (Object)"metadata"));
        Location expected = new LocationBuilder().id("reg1").description("reg1/Region 1").parent((Location)Iterables.getOnlyElement((Iterable)locationsSupplier.get())).scope(LocationScope.REGION).build();
        Location location = new RegionToLocation(locationsSupplier).apply(region);
        Assert.assertEquals((Object)location, (Object)expected);
        Assert.assertEquals(location.getMetadata().get("available"), (Object)true);
        Assert.assertEquals(location.getMetadata().get("features"), (Object)ImmutableList.of((Object)"virtio", (Object)"metadata"));
    }
}

