/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.digitalocean2.compute.functions.ImageInRegionToImage;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ImageToImageTest")
public class ImageInRegionToImageTest {
    private Set<Location> locations;
    private ImageInRegionToImage function;

    @BeforeMethod
    public void setup() {
        this.locations = ImmutableSet.of((Object)new LocationBuilder().id("sfo1").description("sfo1/San Francisco 1").scope(LocationScope.REGION).parent(new LocationBuilder().id("0").description("mock parent location").scope(LocationScope.PROVIDER).build()).build(), (Object)new LocationBuilder().id("lon1").description("lon1/London 1").scope(LocationScope.REGION).parent(new LocationBuilder().id("0").description("mock parent location").scope(LocationScope.PROVIDER).build()).build());
        this.function = new ImageInRegionToImage((Supplier)new Supplier<Set<? extends Location>>(){

            public Set<? extends Location> get() {
                return ImageInRegionToImageTest.this.locations;
            }
        });
    }

    @Test
    public void testConvertImage() {
        Image image = Image.create((int)1, (String)"14.04 x64", (String)"distribution", (String)"Ubuntu", (String)"ubuntu-1404-x86", (boolean)true, (List)ImmutableList.of((Object)"sfo1", (Object)"lon1"), (Date)new Date(), (float)20.0f, (float)20.0f);
        org.jclouds.compute.domain.Image expected = new ImageBuilder().id("lon1/ubuntu-1404-x86").providerId("1").name("14.04 x64").description("Ubuntu 14.04 x64").status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu").description("Ubuntu 14.04 x64").family(OsFamily.UBUNTU).version("14.04").arch("x64").is64Bit(true).build()).location((Location)Iterables.get(this.locations, (int)1)).userMetadata((Map)ImmutableMap.of((Object)"publicImage", (Object)"true")).build();
        org.jclouds.compute.domain.Image result = this.function.apply(ImageInRegion.create((Image)image, (String)"lon1"));
        Assert.assertEquals((Object)result, (Object)expected);
        Assert.assertEquals((String)result.getDescription(), (String)expected.getDescription());
        Assert.assertEquals((Object)result.getOperatingSystem(), (Object)expected.getOperatingSystem());
        Assert.assertEquals((Object)result.getStatus(), (Object)expected.getStatus());
        Assert.assertEquals((Object)result.getLocation(), (Object)Iterables.get(this.locations, (int)1));
    }
}

