/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.digitalocean2.compute.functions.DropletStatusToStatus;
import org.jclouds.digitalocean2.compute.functions.DropletToNodeMetadata;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Networks;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DropletToNodeMetadataTest")
public class DropletToNodeMetadataTest {
    private Image image;
    private Region region;
    private Set<Hardware> hardwares;
    private Set<org.jclouds.compute.domain.Image> images;
    private Set<Location> locations;
    private LoginCredentials credentials;
    private DropletToNodeMetadata function;

    @BeforeMethod
    public void setup() {
        this.image = Image.create((int)1, (String)"14.04 x64", (String)"distribution", (String)"Ubuntu", (String)"ubuntu-1404-x86", (boolean)true, (List)ImmutableList.of((Object)"sfo1"), (Date)new Date(), (float)20.0f, (float)20.0f);
        this.region = Region.create((String)"sfo1", (String)"San Francisco 1", (List)ImmutableList.of((Object)"2gb"), (boolean)true, (List)ImmutableList.of());
        this.images = ImmutableSet.of((Object)new ImageBuilder().id("sfo1/ubuntu-1404-x86").providerId("1").name("mock image").status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 14.04 x86_64").description("Ubuntu").family(OsFamily.UBUNTU).version("10.04").arch("x86_64").is64Bit(true).build()).build());
        this.hardwares = ImmutableSet.of((Object)new HardwareBuilder().id("2gb").providerId("2gb").name("mock hardware").processor(new Processor(1.0, 1.0)).ram(2048).volume(new VolumeBuilder().size(Float.valueOf(20.0f)).type(Volume.Type.LOCAL).build()).build());
        this.locations = ImmutableSet.of((Object)new LocationBuilder().id("sfo1").description("sfo1/San Francisco 1").scope(LocationScope.REGION).parent(new LocationBuilder().id("0").description("mock parent location").scope(LocationScope.PROVIDER).build()).build());
        this.credentials = LoginCredentials.builder().user("foo").password("bar").build();
        this.function = this.createNodeParser(this.hardwares, this.images, this.locations, (Map<String, Credentials>)ImmutableMap.of((Object)"node#1", (Object)this.credentials));
    }

    @Test
    public void testConvertDroplet() throws ParseException {
        Droplet droplet = Droplet.create((int)1, (String)"mock-droplet", (int)1, (int)1, (int)1, (boolean)false, (Date)new Date(), (Droplet.Status)Droplet.Status.ACTIVE, (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Region)this.region, (Image)this.image, null, (String)"2gb", (Networks)Networks.create((List)ImmutableList.of((Object)Networks.Address.create((String)"84.45.69.3", (String)"255.255.255.0", (String)"84.45.69.1", (String)"public"), (Object)Networks.Address.create((String)"192.168.2.5", (String)"255.255.255.0", (String)"192.168.2.1", (String)"private")), (List)ImmutableList.of()), null);
        NodeMetadata expected = new NodeMetadataBuilder().ids("1").hardware((Hardware)Iterables.getOnlyElement(this.hardwares)).imageId("sfo1/ubuntu-1404-x86").status(NodeMetadata.Status.RUNNING).location((Location)Iterables.getOnlyElement(this.locations)).name("mock-droplet").hostname("mock-droplet").group("mock").credentials(this.credentials).publicAddresses((Iterable)ImmutableSet.of((Object)"84.45.69.3")).privateAddresses((Iterable)ImmutableSet.of((Object)"192.168.2.5")).providerId("1").backendStatus(Droplet.Status.ACTIVE.name()).operatingSystem(((org.jclouds.compute.domain.Image)Iterables.getOnlyElement(this.images)).getOperatingSystem()).build();
        NodeMetadata actual = this.function.apply(droplet);
        DropletToNodeMetadataTest.assertNodeEquals(actual, expected);
    }

    @Test
    public void testConvertDropletOldImage() throws ParseException {
        Image image = Image.create((int)2, (String)"14.04 x64", (String)"distribution", (String)"Ubuntu", (String)"ubuntu2-1404-x86", (boolean)true, (List)ImmutableList.of((Object)"sfo1"), (Date)new Date(), (float)20.0f, (float)20.0f);
        Droplet droplet = Droplet.create((int)1, (String)"mock-droplet", (int)1, (int)1, (int)1, (boolean)false, (Date)new Date(), (Droplet.Status)Droplet.Status.ACTIVE, (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Region)this.region, (Image)image, null, (String)"2gb", (Networks)Networks.create((List)ImmutableList.of((Object)Networks.Address.create((String)"84.45.69.3", (String)"255.255.255.0", (String)"84.45.69.1", (String)"public"), (Object)Networks.Address.create((String)"192.168.2.5", (String)"255.255.255.0", (String)"192.168.2.1", (String)"private")), (List)ImmutableList.of()), null);
        NodeMetadata expected = new NodeMetadataBuilder().ids("1").hardware((Hardware)Iterables.getOnlyElement(this.hardwares)).imageId(null).status(NodeMetadata.Status.RUNNING).location((Location)Iterables.getOnlyElement(this.locations)).name("mock-droplet").hostname("mock-droplet").group("mock").credentials(this.credentials).publicAddresses((Iterable)ImmutableSet.of((Object)"84.45.69.3")).privateAddresses((Iterable)ImmutableSet.of((Object)"192.168.2.5")).providerId("1").backendStatus(Droplet.Status.ACTIVE.name()).operatingSystem(null).build();
        NodeMetadata actual = this.function.apply(droplet);
        DropletToNodeMetadataTest.assertNodeEquals(actual, expected);
    }

    private static void assertNodeEquals(NodeMetadata actual, NodeMetadata expected) {
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertEquals((Object)actual.getStatus(), (Object)expected.getStatus());
        Assert.assertEquals((String)actual.getBackendStatus(), (String)expected.getBackendStatus());
        Assert.assertEquals((int)actual.getLoginPort(), (int)expected.getLoginPort());
        Assert.assertEquals((Set)actual.getPublicAddresses(), (Set)expected.getPublicAddresses());
        Assert.assertEquals((Set)actual.getPrivateAddresses(), (Set)expected.getPrivateAddresses());
        Assert.assertEquals((Object)actual.getCredentials(), (Object)expected.getCredentials());
        Assert.assertEquals((String)actual.getGroup(), (String)expected.getGroup());
        Assert.assertEquals((String)actual.getImageId(), (String)expected.getImageId());
        Assert.assertEquals((Object)actual.getHardware(), (Object)expected.getHardware());
        Assert.assertEquals((Object)actual.getOperatingSystem(), (Object)expected.getOperatingSystem());
        Assert.assertEquals((String)actual.getHostname(), (String)expected.getHostname());
    }

    private DropletToNodeMetadata createNodeParser(final Set<Hardware> hardware, final Set<org.jclouds.compute.domain.Image> images, final Set<Location> locations, Map<String, Credentials> credentialStore) {
        Supplier<Set<? extends Location>> locationSupplier = new Supplier<Set<? extends Location>>(){

            public Set<? extends Location> get() {
                return locations;
            }
        };
        Supplier<Map<String, ? extends Hardware>> hardwareSupplier = new Supplier<Map<String, ? extends Hardware>>(){

            public Map<String, ? extends Hardware> get() {
                return Maps.uniqueIndex((Iterable)hardware, (Function)new Function<Hardware, String>(){

                    public String apply(Hardware input) {
                        return input.getId();
                    }
                });
            }
        };
        Supplier<Map<String, ? extends org.jclouds.compute.domain.Image>> imageSupplier = new Supplier<Map<String, ? extends org.jclouds.compute.domain.Image>>(){

            public Map<String, ? extends org.jclouds.compute.domain.Image> get() {
                return Maps.uniqueIndex((Iterable)images, (Function)new Function<org.jclouds.compute.domain.Image, String>(){

                    public String apply(org.jclouds.compute.domain.Image input) {
                        return input.getId();
                    }
                });
            }
        };
        GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(GroupNamingConvention.Factory.class);
        return new DropletToNodeMetadata((Supplier)imageSupplier, (Supplier)hardwareSupplier, (Supplier)locationSupplier, (Function)new DropletStatusToStatus(), namingConvention, credentialStore);
    }
}

