/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.config;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.easymock.EasyMock;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.config.DigitalOcean2ComputeServiceContextModule;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.features.DropletApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DropletTerminatedPredicateTest")
public class DropletTerminatedPredicateTest {
    public void testDropletTerminated() {
        DropletApi dropletApi = (DropletApi)EasyMock.createMock(DropletApi.class);
        DigitalOcean2Api api = (DigitalOcean2Api)EasyMock.createMock(DigitalOcean2Api.class);
        EasyMock.expect((Object)dropletApi.get(1)).andReturn((Object)DropletTerminatedPredicateTest.mockDroplet());
        EasyMock.expect((Object)dropletApi.get(2)).andReturn(null);
        EasyMock.expect((Object)api.dropletApi()).andReturn((Object)dropletApi).times(2);
        EasyMock.replay((Object[])new Object[]{dropletApi, api});
        DigitalOcean2ComputeServiceContextModule.DropletTerminatedPredicate predicate = new DigitalOcean2ComputeServiceContextModule.DropletTerminatedPredicate(api);
        Assert.assertFalse((boolean)predicate.apply(Integer.valueOf(1)));
        Assert.assertTrue((boolean)predicate.apply(Integer.valueOf(2)));
    }

    private static Droplet mockDroplet() {
        return Droplet.create((int)1, (String)"foo", (int)1024, (int)1, (int)20, (boolean)false, (Date)new Date(), (Droplet.Status)Droplet.Status.ACTIVE, (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), null, null, null, (String)"", null, null);
    }
}

