/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.config;

import java.util.Date;
import org.easymock.EasyMock;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.config.DigitalOcean2ComputeServiceContextModule;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.features.ActionApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ActionDonePredicateTest")
public class ActionDonePredicateTest {
    public void testActionStatusOk() {
        ActionApi actionApi = (ActionApi)EasyMock.createMock(ActionApi.class);
        DigitalOcean2Api api = (DigitalOcean2Api)EasyMock.createMock(DigitalOcean2Api.class);
        EasyMock.expect((Object)actionApi.get(1)).andReturn((Object)ActionDonePredicateTest.action(Action.Status.COMPLETED));
        EasyMock.expect((Object)actionApi.get(2)).andReturn((Object)ActionDonePredicateTest.action(Action.Status.IN_PROGRESS));
        EasyMock.expect((Object)api.actionApi()).andReturn((Object)actionApi).times(2);
        EasyMock.replay((Object[])new Object[]{actionApi, api});
        DigitalOcean2ComputeServiceContextModule.ActionDonePredicate predicate = new DigitalOcean2ComputeServiceContextModule.ActionDonePredicate(api);
        Assert.assertTrue((boolean)predicate.apply(Integer.valueOf(1)));
        Assert.assertFalse((boolean)predicate.apply(Integer.valueOf(2)));
    }

    public void testActionStatusError() {
        ActionApi actionApi = (ActionApi)EasyMock.createMock(ActionApi.class);
        DigitalOcean2Api api = (DigitalOcean2Api)EasyMock.createMock(DigitalOcean2Api.class);
        EasyMock.expect((Object)actionApi.get(EasyMock.anyInt())).andReturn((Object)ActionDonePredicateTest.action(Action.Status.ERRORED));
        EasyMock.expect((Object)api.actionApi()).andReturn((Object)actionApi);
        EasyMock.replay((Object[])new Object[]{actionApi, api});
        DigitalOcean2ComputeServiceContextModule.ActionDonePredicate predicate = new DigitalOcean2ComputeServiceContextModule.ActionDonePredicate(api);
        try {
            predicate.apply(Integer.valueOf(1));
            Assert.fail((String)"Method should have thrown an IllegalStateException");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((String)ex.getMessage(), (String)"Resource is in invalid status: ERRORED");
        }
    }

    private static Action action(Action.Status status) {
        return Action.create((int)1, (Action.Status)status, (String)"foo", (Date)new Date(), (Date)new Date(), (long)1L, (String)"", null, (String)"");
    }
}

