/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="DigitalOcean2TemplateBuilderLiveTest")
public class DigitalOcean2TemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public DigitalOcean2TemplateBuilderLiveTest() {
        this.provider = "digitalocean2";
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        assert (defaultTemplate.getImage().getOperatingSystem().getVersion().startsWith("16.")) : defaultTemplate.getImage().getOperatingSystem().getVersion();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of();
    }
}

