/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.xml;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.internal.BlobBlockPropertiesImpl;
import org.jclouds.azureblob.domain.internal.ListBlobBlocksResponseImpl;
import org.jclouds.azureblob.xml.BlobBlocksResultsHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BlobBlocksResultsHandlerTest")
public class BlobBlocksResultsHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
    }

    public void testGetResult() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test_list_blob_blocks.xml");
        LinkedList blocks = Lists.newLinkedList();
        blocks.add(new BlobBlockPropertiesImpl("blockIdA", 1234L, true));
        blocks.add(new BlobBlockPropertiesImpl("blockIdB", 4321L, true));
        blocks.add(new BlobBlockPropertiesImpl("blockIdC", 5678L, false));
        blocks.add(new BlobBlockPropertiesImpl("blockIdD", 8765L, false));
        ListBlobBlocksResponseImpl expected = new ListBlobBlocksResponseImpl((List)blocks);
        ListBlobBlocksResponse result = (ListBlobBlocksResponse)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(BlobBlocksResultsHandler.class)).parse(is);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

