/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.integration;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobIntegrationTest;
import org.jclouds.blobstore.options.CopyOptions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class AzureBlobIntegrationLiveTest
extends BaseBlobIntegrationTest {
    protected long getMinimumMultipartBlobSize() {
        return ((BlobStoreContext)this.view).getBlobStore().getMaximumMultipartPartSize() + 1L;
    }

    public AzureBlobIntegrationLiveTest() {
        this.provider = "azureblob";
    }

    public void testGetIfMatch() throws InterruptedException {
        throw new SkipException("not yet implemented");
    }

    public void testCreateBlobWithExpiry() throws InterruptedException {
        throw new SkipException("Expires header unsupported: http://msdn.microsoft.com/en-us/library/windowsazure/dd179404.aspx#Subheading3");
    }

    @Test
    public void testPutObjectStream() throws InterruptedException, IOException, ExecutionException {
        throw new SkipException("Azure requires a Content-Length");
    }

    @Test(groups={"integration", "live"})
    public void testSetBlobAccess() throws Exception {
        throw new SkipException("unsupported in Azure");
    }

    @Test(groups={"integration", "live"}, expectedExceptions={UnsupportedOperationException.class})
    public void testPutBlobAccess() throws Exception {
        super.testPutBlobAccess();
    }

    @Test(groups={"integration", "live"}, expectedExceptions={UnsupportedOperationException.class})
    public void testPutBlobAccessMultipart() throws Exception {
        super.testPutBlobAccessMultipart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testSigningOfUppercaseMetadata() throws InterruptedException {
        String containerName = this.getContainerName();
        String blobName = "testSigningOfUppercaseMetadata";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(blobName).userMetadata((Map)ImmutableMap.of((Object)"B", (Object)"b", (Object)"a", (Object)"a")).payload(TEST_STRING).contentType("text/plain").contentMD5(Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8)).build();
        try {
            Assert.assertNull((Object)((BlobStoreContext)this.view).getBlobStore().blobMetadata(containerName, blobName));
            this.addBlobToContainer(containerName, blob);
            this.assertConsistencyAwareContainerSize(containerName, 1);
            ((BlobStoreContext)this.view).getBlobStore().copyBlob(containerName, blobName, containerName, blobName, CopyOptions.builder().userMetadata((Map)ImmutableMap.of((Object)"B", (Object)"b", (Object)"a", (Object)"a")).build());
            Blob newObject = ((BlobStoreContext)this.view).getBlobStore().getBlob(containerName, blobName);
            Assert.assertNotNull((Object)newObject);
            Assert.assertEquals((String)((String)newObject.getMetadata().getUserMetadata().get("b")), (String)"b");
            Assert.assertEquals((String)((String)newObject.getMetadata().getUserMetadata().get("a")), (String)"a");
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

