/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Supplier;
import com.google.common.hash.HashCode;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Date;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.AzureBlobProviderMetadata;
import org.jclouds.azureblob.blobstore.AzureBlobRequestSigner;
import org.jclouds.azureblob.config.AzureBlobHttpApiModule;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseRestAnnotationProcessingTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AzureBlobRequestSignerTest")
public class AzureBlobRequestSignerTest
extends BaseRestAnnotationProcessingTest<AzureBlobClient> {
    private AzureBlobRequestSigner signer;
    private Blob.Factory blobFactory;

    public AzureBlobRequestSignerTest() {
        this.credential = "aaaabbbb";
    }

    public void testSignGetBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signGetBlob("container", "name");
        this.assertRequestLineEquals(request, "GET https://identity.blob.core.windows.net/container/name?sv=2017-04-17&se=2008-06-05T16%3A53%3A19Z&sr=b&sp=r&sig=HzCwPCszb39utrHpHKFK6eeZWHJVLcaIwJYXVUgJ%2BQo%3D HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Date: Thu, 05 Jun 2008 16:38:19 GMT\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignRemoveBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signRemoveBlob("container", "name");
        this.assertRequestLineEquals(request, "DELETE https://identity.blob.core.windows.net/container/name?sv=2017-04-17&se=2008-06-05T16%3A53%3A19Z&sr=b&sp=d&sig=xyHwMhO1Dg2LoJH/VoXeLraAp1FBWjdfcc0y31LMKnY%3D HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Date: Thu, 05 Jun 2008 16:38:19 GMT\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignPutBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HashCode hashCode = HashCode.fromBytes((byte[])new byte[16]);
        Blob blob = this.blobFactory.create(null);
        blob.getMetadata().setName("name");
        blob.setPayload("");
        blob.getPayload().getContentMetadata().setContentLength(Long.valueOf(2L));
        blob.getPayload().getContentMetadata().setContentMD5(hashCode);
        blob.getPayload().getContentMetadata().setContentType("text/plain");
        blob.getPayload().getContentMetadata().setExpires(new Date(1000L));
        HttpRequest request = this.signer.signPutBlob("container", blob);
        this.assertRequestLineEquals(request, "PUT https://identity.blob.core.windows.net/container/name?sv=2017-04-17&se=2008-06-05T16%3A53%3A19Z&sr=b&sp=w&sig=blX/iud63gLIPVkDEeTYreIopqiVmHalxfrFFsHMJFc%3D HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Content-Length: 2\nDate: Thu, 05 Jun 2008 16:38:19 GMT\nx-ms-blob-content-type: text/plain\nx-ms-blob-type: BlockBlob\n");
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.blobFactory = (Blob.Factory)this.injector.getInstance(Blob.Factory.class);
        this.signer = (AzureBlobRequestSigner)((BlobRequestSigner)this.injector.getInstance(BlobRequestSigner.class));
    }

    protected void checkFilters(HttpRequest request) {
    }

    protected Module createModule() {
        return new TestAzureBlobHttpApiModule();
    }

    public AzureBlobProviderMetadata createProviderMetadata() {
        return new AzureBlobProviderMetadata();
    }

    @ConfiguresHttpApi
    private static final class TestAzureBlobHttpApiModule
    extends AzureBlobHttpApiModule {
        private TestAzureBlobHttpApiModule() {
        }

        protected void configure() {
            super.configure();
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "Thu, 05 Jun 2008 16:38:19 GMT";
        }
    }
}

