/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.AzureBlobProviderMetadata;
import org.jclouds.azureblob.binders.BindAzureBlobMetadataToRequest;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.internal.BaseRestAnnotationProcessingTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindAzureBlobMetadataToRequestTest")
public class BindAzureBlobMetadataToRequestTest
extends BaseRestAnnotationProcessingTest<AzureBlobClient> {
    @Test
    public void testPassWithMinimumDetailsAndPayload256MB() {
        AzureBlob blob = ((AzureBlob.Factory)this.injector.getInstance(AzureBlob.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x10000000L));
        blob.setPayload((Payload)payload);
        blob.getProperties().setName("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindAzureBlobMetadataToRequest binder = (BindAzureBlobMetadataToRequest)this.injector.getInstance(BindAzureBlobMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)blob), (Object)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost").addHeader("x-ms-blob-type", new String[]{"BlockBlob"})).build());
    }

    @Test
    public void testExtendedPropertiesBind() {
        AzureBlob blob = ((AzureBlob.Factory)this.injector.getInstance(AzureBlob.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x10000000L));
        blob.setPayload((Payload)payload);
        blob.getProperties().setName("foo");
        blob.getProperties().setMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindAzureBlobMetadataToRequest binder = (BindAzureBlobMetadataToRequest)this.injector.getInstance(BindAzureBlobMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)blob), (Object)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost").addHeader("x-ms-blob-type", new String[]{"BlockBlob"})).addHeader("x-ms-meta-foo", new String[]{"bar"})).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNoContentLengthIsBad() {
        AzureBlob blob = ((AzureBlob.Factory)this.injector.getInstance(AzureBlob.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(null);
        blob.setPayload((Payload)payload);
        blob.getProperties().setName("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindAzureBlobMetadataToRequest binder = (BindAzureBlobMetadataToRequest)this.injector.getInstance(BindAzureBlobMetadataToRequest.class);
        binder.bindToRequest(request, (Object)blob);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNoNameIsBad() {
        AzureBlob blob = ((AzureBlob.Factory)this.injector.getInstance(AzureBlob.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(5368709120000L));
        blob.setPayload((Payload)payload);
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindAzureBlobMetadataToRequest binder = (BindAzureBlobMetadataToRequest)this.injector.getInstance(BindAzureBlobMetadataToRequest.class);
        binder.bindToRequest(request, (Object)blob);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOver256MBIsBad() {
        AzureBlob blob = ((AzureBlob.Factory)this.injector.getInstance(AzureBlob.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x10000001L));
        blob.setPayload((Payload)payload);
        blob.getProperties().setName("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindAzureBlobMetadataToRequest binder = (BindAzureBlobMetadataToRequest)this.injector.getInstance(BindAzureBlobMetadataToRequest.class);
        binder.bindToRequest(request, (Object)blob);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeAzureBlob() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        ((BindAzureBlobMetadataToRequest)this.injector.getInstance(BindAzureBlobMetadataToRequest.class)).bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindAzureBlobMetadataToRequest binder = (BindAzureBlobMetadataToRequest)this.injector.getInstance(BindAzureBlobMetadataToRequest.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }

    protected void checkFilters(HttpRequest request) {
    }

    public AzureBlobProviderMetadata createProviderMetadata() {
        return new AzureBlobProviderMetadata();
    }
}

