/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jclouds.ContextBuilder;
import org.jclouds.Fallbacks;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.AzureBlobFallbacks;
import org.jclouds.azureblob.AzureBlobProviderMetadata;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.ListBlobsInclude;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.functions.ParseBlobFromHeadersAndHttpContent;
import org.jclouds.azureblob.functions.ParseContainerPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParsePublicAccessHeader;
import org.jclouds.azureblob.options.CopyBlobOptions;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.azureblob.xml.AccountNameEnumerationResultsHandler;
import org.jclouds.azureblob.xml.ContainerNameEnumerationResultsHandler;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseRestAnnotationProcessingTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AzureBlobClientTest")
public class AzureBlobClientTest
extends BaseRestAnnotationProcessingTest<AzureBlobClient> {
    private static AzureBlobClient getAzureBlobClient() {
        return (AzureBlobClient)ContextBuilder.newBuilder((String)"azureblob").credentials("accessKey", "secretKey").buildApi(AzureBlobClient.class);
    }

    public void testListContainers() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"listContainers", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/?comp=list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AccountNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testListContainersOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"listContainers", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.maxResults((int)1).marker("marker").prefix("prefix")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/?comp=list&maxresults=1&marker=marker&prefix=prefix HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AccountNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testCreateContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"createContainer", (Class[])new Class[]{String.class, CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testDeleteContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"deleteContainer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
    }

    public void testCreateContainerOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"createContainer", (Class[])new Class[]{String.class, CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)CreateContainerOptions.Builder.withPublicAccess((PublicAccess)PublicAccess.BLOB).withMetadata((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"bar"))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-blob-public-access: blob\nx-ms-meta-foo: bar\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testCreateRootContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"createRootContainer", (Class[])new Class[]{CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/$root?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testDeleteRootContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"deleteRootContainer", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://identity.blob.core.windows.net/$root?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.TrueOnNotFoundOr404.class);
    }

    public void testCreateRootContainerOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"createRootContainer", (Class[])new Class[]{CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)CreateContainerOptions.Builder.withPublicAccess((PublicAccess)PublicAccess.BLOB).withMetadata((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"bar"))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/$root?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-blob-public-access: blob\nx-ms-meta-foo: bar\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testListBlobs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"listBlobs", (Class[])new Class[]{String.class, ListBlobsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/container?restype=container&comp=list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ContainerNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testListBlobsWithOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"listBlobs", (Class[])new Class[]{String.class, ListBlobsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)new ListBlobsOptions().include(EnumSet.allOf(ListBlobsInclude.class))));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/container?restype=container&comp=list&include=copy,metadata,snapshots,uncommittedblobs HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ContainerNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testListRootBlobs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"listBlobs", (Class[])new Class[]{ListBlobsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/$root?restype=container&comp=list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ContainerNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testContainerProperties() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"getContainerProperties", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseContainerPropertiesFromHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnContainerNotFound.class);
    }

    public void testGetPublicAccessForContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"getPublicAccessForContainer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://identity.blob.core.windows.net/container?restype=container&comp=acl HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParsePublicAccessHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnContainerNotFound.class);
    }

    public void testSetPublicAccessForContainer() throws SecurityException, NoSuchMethodException, IOException {
        this.setAndVerifyPublicAccessForContainer(PublicAccess.CONTAINER, "x-ms-blob-public-access: container\n");
        this.setAndVerifyPublicAccessForContainer(PublicAccess.BLOB, "x-ms-blob-public-access: blob\n");
        this.setAndVerifyPublicAccessForContainer(PublicAccess.PRIVATE, "");
    }

    private void setAndVerifyPublicAccessForContainer(PublicAccess access, String expectedHeader) {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"setPublicAccessForContainer", (Class[])new Class[]{String.class, PublicAccess.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)access));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container?restype=container&comp=acl HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, expectedHeader + "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseETagHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    public void testSetResourceMetadata() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"setResourceMetadata", (Class[])new Class[]{String.class, Map.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)ImmutableMap.of((Object)"key", (Object)"value")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container?restype=container&comp=metadata HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-meta-key: value\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    public void testPutBlob() throws Exception {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"putBlob", (Class[])new Class[]{String.class, AzureBlob.class});
        String payload = "payload";
        String cacheControl = "max-age=3600";
        AzureBlob object = AzureBlobClientTest.getAzureBlobClient().newBlob();
        object.setPayload(payload);
        object.getProperties().setName("blob");
        object.getProperties().getContentMetadata().setCacheControl(cacheControl);
        object.getProperties().getContentMetadata().setContentLength(Long.valueOf(7L));
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)object));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container/blob HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Expect: 100-continue\nx-ms-blob-cache-control: " + cacheControl + "\n" + "x-ms-blob-type: BlockBlob\n" + "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, payload, "application/unknown", false);
        this.assertResponseParserClassEquals(method, request, ParseETagHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    public void testGetBlob() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"getBlob", (Class[])new Class[]{String.class, String.class, GetOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)"blob"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/container/blob HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseBlobFromHeadersAndHttpContent.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnKeyNotFound.class);
    }

    public void testSetBlobMetadata() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"setBlobMetadata", (Class[])new Class[]{String.class, String.class, Map.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)"blob", (Object)ImmutableMap.of((Object)"key", (Object)"value")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container/blob?comp=metadata HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-meta-key: value\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseETagHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    public void testSetBlobProperties() throws Exception {
        String cacheControl = "max-age=3600";
        ContentMetadata metadata = ContentMetadataBuilder.create().cacheControl(cacheControl).build();
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"setBlobProperties", (Class[])new Class[]{String.class, String.class, ContentMetadata.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)"blob", (Object)metadata));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container/blob?comp=properties HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-blob-cache-control: " + cacheControl + "\n" + "x-ms-blob-content-type: application/unknown\n" + "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseETagHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    public void testSetBlobTier() throws Exception {
        AccessTier tier = AccessTier.COOL;
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"setBlobTier", (Class[])new Class[]{String.class, String.class, AccessTier.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)"blob", (Object)tier));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container/blob?comp=tier HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-access-tier: " + tier + "\n" + "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    public void testCopyBlob() throws Exception {
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"copyBlob", (Class[])new Class[]{URI.class, String.class, String.class, CopyBlobOptions.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://identity.blob.core.windows.net/fromcontainer/fromblob"), (Object)"tocontainer", (Object)"toblob", (Object)CopyBlobOptions.NONE));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/tocontainer/toblob HTTP/1.1");
        this.checkFilters((HttpRequest)request);
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-copy-source: https://identity.blob.core.windows.net/fromcontainer/fromblob\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testCopyBlobOverwriteUserMetadata() throws Exception {
        CopyBlobOptions options = CopyBlobOptions.builder().overrideUserMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build();
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"copyBlob", (Class[])new Class[]{URI.class, String.class, String.class, CopyBlobOptions.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://identity.blob.core.windows.net/fromcontainer/fromblob"), (Object)"tocontainer", (Object)"toblob", (Object)options));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/tocontainer/toblob HTTP/1.1");
        this.checkFilters((HttpRequest)request);
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-copy-source: https://identity.blob.core.windows.net/fromcontainer/fromblob\nx-ms-meta-foo: bar\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testCopyBlobIfModifiedSince() throws Exception {
        CopyBlobOptions options = CopyBlobOptions.builder().ifModifiedSince(new Date(1000L)).build();
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"copyBlob", (Class[])new Class[]{URI.class, String.class, String.class, CopyBlobOptions.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://identity.blob.core.windows.net/fromcontainer/fromblob"), (Object)"tocontainer", (Object)"toblob", (Object)options));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/tocontainer/toblob HTTP/1.1");
        this.checkFilters((HttpRequest)request);
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-copy-source: https://identity.blob.core.windows.net/fromcontainer/fromblob\nx-ms-source-if-modified-since: Thu, 01 Jan 1970 00:00:01 GMT\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testCopyBlobIfUnmodifiedSince() throws Exception {
        CopyBlobOptions options = CopyBlobOptions.builder().ifUnmodifiedSince(new Date(1000L)).build();
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"copyBlob", (Class[])new Class[]{URI.class, String.class, String.class, CopyBlobOptions.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://identity.blob.core.windows.net/fromcontainer/fromblob"), (Object)"tocontainer", (Object)"toblob", (Object)options));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/tocontainer/toblob HTTP/1.1");
        this.checkFilters((HttpRequest)request);
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-copy-source: https://identity.blob.core.windows.net/fromcontainer/fromblob\nx-ms-source-if-unmodified-since: Thu, 01 Jan 1970 00:00:01 GMT\nx-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testCopyBlobIfMatch() throws Exception {
        String eTag = "0x8CEB669D794AFE2";
        CopyBlobOptions options = CopyBlobOptions.builder().ifMatch(eTag).build();
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"copyBlob", (Class[])new Class[]{URI.class, String.class, String.class, CopyBlobOptions.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://identity.blob.core.windows.net/fromcontainer/fromblob"), (Object)"tocontainer", (Object)"toblob", (Object)options));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/tocontainer/toblob HTTP/1.1");
        this.checkFilters((HttpRequest)request);
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-copy-source: https://identity.blob.core.windows.net/fromcontainer/fromblob\nx-ms-source-if-match: " + eTag + "\n" + "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    public void testCopyBlobIfNoneMatch() throws Exception {
        String eTag = "0x8CEB669D794AFE2";
        CopyBlobOptions options = CopyBlobOptions.builder().ifNoneMatch(eTag).build();
        Invokable method = Reflection2.method(AzureBlobClient.class, (String)"copyBlob", (Class[])new Class[]{URI.class, String.class, String.class, CopyBlobOptions.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://identity.blob.core.windows.net/fromcontainer/fromblob"), (Object)"tocontainer", (Object)"toblob", (Object)options));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/tocontainer/toblob HTTP/1.1");
        this.checkFilters((HttpRequest)request);
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-copy-source: https://identity.blob.core.windows.net/fromcontainer/fromblob\nx-ms-source-if-none-match: " + eTag + "\n" + "x-ms-version: 2017-04-17\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SharedKeyLiteAuthentication.class);
    }

    public AzureBlobProviderMetadata createProviderMetadata() {
        return new AzureBlobProviderMetadata();
    }
}

